package safe

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryInnerProductInfo invokes the safe.QueryInnerProductInfo API synchronously
func (client *Client) QueryInnerProductInfo(request *QueryInnerProductInfoRequest) (response *QueryInnerProductInfoResponse, err error) {
	response = CreateQueryInnerProductInfoResponse()
	err = client.DoAction(request, response)
	return
}

// QueryInnerProductInfoWithChan invokes the safe.QueryInnerProductInfo API asynchronously
func (client *Client) QueryInnerProductInfoWithChan(request *QueryInnerProductInfoRequest) (<-chan *QueryInnerProductInfoResponse, <-chan error) {
	responseChan := make(chan *QueryInnerProductInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryInnerProductInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryInnerProductInfoWithCallback invokes the safe.QueryInnerProductInfo API asynchronously
func (client *Client) QueryInnerProductInfoWithCallback(request *QueryInnerProductInfoRequest, callback func(response *QueryInnerProductInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryInnerProductInfoResponse
		var err error
		defer close(result)
		response, err = client.QueryInnerProductInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryInnerProductInfoRequest is the request struct for api QueryInnerProductInfo
type QueryInnerProductInfoRequest struct {
	*requests.RpcRequest
	AuthKey      string           `position:"Body" name:"AuthKey"`
	ReqTimestamp requests.Integer `position:"Body" name:"ReqTimestamp"`
	ProductCode  string           `position:"Body" name:"ProductCode"`
	Limit        requests.Integer `position:"Body" name:"Limit"`
	AuthSign     string           `position:"Body" name:"AuthSign"`
	Page         requests.Integer `position:"Body" name:"Page"`
}

// QueryInnerProductInfoResponse is the response struct for api QueryInnerProductInfo
type QueryInnerProductInfoResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateQueryInnerProductInfoRequest creates a request to invoke QueryInnerProductInfo API
func CreateQueryInnerProductInfoRequest() (request *QueryInnerProductInfoRequest) {
	request = &QueryInnerProductInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Safe", "2022-01-17", "QueryInnerProductInfo", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryInnerProductInfoResponse creates a response to parse from QueryInnerProductInfo response
func CreateQueryInnerProductInfoResponse() (response *QueryInnerProductInfoResponse) {
	response = &QueryInnerProductInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
