package safe

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ChangeCancel invokes the safe.ChangeCancel API synchronously
func (client *Client) ChangeCancel(request *ChangeCancelRequest) (response *ChangeCancelResponse, err error) {
	response = CreateChangeCancelResponse()
	err = client.DoAction(request, response)
	return
}

// ChangeCancelWithChan invokes the safe.ChangeCancel API asynchronously
func (client *Client) ChangeCancelWithChan(request *ChangeCancelRequest) (<-chan *ChangeCancelResponse, <-chan error) {
	responseChan := make(chan *ChangeCancelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ChangeCancel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ChangeCancelWithCallback invokes the safe.ChangeCancel API asynchronously
func (client *Client) ChangeCancelWithCallback(request *ChangeCancelRequest, callback func(response *ChangeCancelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ChangeCancelResponse
		var err error
		defer close(result)
		response, err = client.ChangeCancel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ChangeCancelRequest is the request struct for api ChangeCancel
type ChangeCancelRequest struct {
	*requests.RpcRequest
	AuthKey       string           `position:"Query" name:"AuthKey"`
	ReqTimestamp  requests.Integer `position:"Query" name:"ReqTimestamp"`
	SourceOrderId string           `position:"Query" name:"SourceOrderId"`
	AuthSign      string           `position:"Query" name:"AuthSign"`
}

// ChangeCancelResponse is the response struct for api ChangeCancel
type ChangeCancelResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
	Code      int    `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateChangeCancelRequest creates a request to invoke ChangeCancel API
func CreateChangeCancelRequest() (request *ChangeCancelRequest) {
	request = &ChangeCancelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Safe", "2022-01-17", "ChangeCancel", "", "")
	request.Method = requests.POST
	return
}

// CreateChangeCancelResponse creates a response to parse from ChangeCancel response
func CreateChangeCancelResponse() (response *ChangeCancelResponse) {
	response = &ChangeCancelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
