package sae

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListNamespaceChangeOrders invokes the sae.ListNamespaceChangeOrders API synchronously
func (client *Client) ListNamespaceChangeOrders(request *ListNamespaceChangeOrdersRequest) (response *ListNamespaceChangeOrdersResponse, err error) {
	response = CreateListNamespaceChangeOrdersResponse()
	err = client.DoAction(request, response)
	return
}

// ListNamespaceChangeOrdersWithChan invokes the sae.ListNamespaceChangeOrders API asynchronously
func (client *Client) ListNamespaceChangeOrdersWithChan(request *ListNamespaceChangeOrdersRequest) (<-chan *ListNamespaceChangeOrdersResponse, <-chan error) {
	responseChan := make(chan *ListNamespaceChangeOrdersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListNamespaceChangeOrders(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListNamespaceChangeOrdersWithCallback invokes the sae.ListNamespaceChangeOrders API asynchronously
func (client *Client) ListNamespaceChangeOrdersWithCallback(request *ListNamespaceChangeOrdersRequest, callback func(response *ListNamespaceChangeOrdersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListNamespaceChangeOrdersResponse
		var err error
		defer close(result)
		response, err = client.ListNamespaceChangeOrders(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListNamespaceChangeOrdersRequest is the request struct for api ListNamespaceChangeOrders
type ListNamespaceChangeOrdersRequest struct {
	*requests.RoaRequest
	CoType      string           `position:"Query" name:"CoType"`
	NamespaceId string           `position:"Query" name:"NamespaceId"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
	CoStatus    string           `position:"Query" name:"CoStatus"`
	Key         string           `position:"Query" name:"Key"`
}

// ListNamespaceChangeOrdersResponse is the response struct for api ListNamespaceChangeOrders
type ListNamespaceChangeOrdersResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	TraceId   string `json:"TraceId" xml:"TraceId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateListNamespaceChangeOrdersRequest creates a request to invoke ListNamespaceChangeOrders API
func CreateListNamespaceChangeOrdersRequest() (request *ListNamespaceChangeOrdersRequest) {
	request = &ListNamespaceChangeOrdersRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("sae", "2019-05-06", "ListNamespaceChangeOrders", "/pop/v1/sam/changeorder/listNamespaceChangeOrders", "serverless", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListNamespaceChangeOrdersResponse creates a response to parse from ListNamespaceChangeOrders response
func CreateListNamespaceChangeOrdersResponse() (response *ListNamespaceChangeOrdersResponse) {
	response = &ListNamespaceChangeOrdersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
