package retailadvqa_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RecieveUserMessage invokes the retailadvqa_public.RecieveUserMessage API synchronously
func (client *Client) RecieveUserMessage(request *RecieveUserMessageRequest) (response *RecieveUserMessageResponse, err error) {
	response = CreateRecieveUserMessageResponse()
	err = client.DoAction(request, response)
	return
}

// RecieveUserMessageWithChan invokes the retailadvqa_public.RecieveUserMessage API asynchronously
func (client *Client) RecieveUserMessageWithChan(request *RecieveUserMessageRequest) (<-chan *RecieveUserMessageResponse, <-chan error) {
	responseChan := make(chan *RecieveUserMessageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RecieveUserMessage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RecieveUserMessageWithCallback invokes the retailadvqa_public.RecieveUserMessage API asynchronously
func (client *Client) RecieveUserMessageWithCallback(request *RecieveUserMessageRequest, callback func(response *RecieveUserMessageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RecieveUserMessageResponse
		var err error
		defer close(result)
		response, err = client.RecieveUserMessage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RecieveUserMessageRequest is the request struct for api RecieveUserMessage
type RecieveUserMessageRequest struct {
	*requests.RpcRequest
	OrganizationId              string `position:"Query" name:"OrganizationId"`
	AccessId                    string `position:"Query" name:"AccessId"`
	CustomerMessageModelListStr string `position:"Body" name:"CustomerMessageModelListStr"`
}

// RecieveUserMessageResponse is the response struct for api RecieveUserMessage
type RecieveUserMessageResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	ErrorDesc string `json:"ErrorDesc" xml:"ErrorDesc"`
	TraceId   string `json:"TraceId" xml:"TraceId"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateRecieveUserMessageRequest creates a request to invoke RecieveUserMessage API
func CreateRecieveUserMessageRequest() (request *RecieveUserMessageRequest) {
	request = &RecieveUserMessageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailadvqa-public", "2020-05-15", "RecieveUserMessage", "", "")
	request.Method = requests.POST
	return
}

// CreateRecieveUserMessageResponse creates a response to parse from RecieveUserMessage response
func CreateRecieveUserMessageResponse() (response *RecieveUserMessageResponse) {
	response = &RecieveUserMessageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
