package resourcesharing

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckSharingWithResourceDirectoryStatus invokes the resourcesharing.CheckSharingWithResourceDirectoryStatus API synchronously
func (client *Client) CheckSharingWithResourceDirectoryStatus(request *CheckSharingWithResourceDirectoryStatusRequest) (response *CheckSharingWithResourceDirectoryStatusResponse, err error) {
	response = CreateCheckSharingWithResourceDirectoryStatusResponse()
	err = client.DoAction(request, response)
	return
}

// CheckSharingWithResourceDirectoryStatusWithChan invokes the resourcesharing.CheckSharingWithResourceDirectoryStatus API asynchronously
func (client *Client) CheckSharingWithResourceDirectoryStatusWithChan(request *CheckSharingWithResourceDirectoryStatusRequest) (<-chan *CheckSharingWithResourceDirectoryStatusResponse, <-chan error) {
	responseChan := make(chan *CheckSharingWithResourceDirectoryStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckSharingWithResourceDirectoryStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckSharingWithResourceDirectoryStatusWithCallback invokes the resourcesharing.CheckSharingWithResourceDirectoryStatus API asynchronously
func (client *Client) CheckSharingWithResourceDirectoryStatusWithCallback(request *CheckSharingWithResourceDirectoryStatusRequest, callback func(response *CheckSharingWithResourceDirectoryStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckSharingWithResourceDirectoryStatusResponse
		var err error
		defer close(result)
		response, err = client.CheckSharingWithResourceDirectoryStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckSharingWithResourceDirectoryStatusRequest is the request struct for api CheckSharingWithResourceDirectoryStatus
type CheckSharingWithResourceDirectoryStatusRequest struct {
	*requests.RpcRequest
}

// CheckSharingWithResourceDirectoryStatusResponse is the response struct for api CheckSharingWithResourceDirectoryStatus
type CheckSharingWithResourceDirectoryStatusResponse struct {
	*responses.BaseResponse
	RequestId           string `json:"RequestId" xml:"RequestId"`
	EnableSharingWithRd bool   `json:"EnableSharingWithRd" xml:"EnableSharingWithRd"`
}

// CreateCheckSharingWithResourceDirectoryStatusRequest creates a request to invoke CheckSharingWithResourceDirectoryStatus API
func CreateCheckSharingWithResourceDirectoryStatusRequest() (request *CheckSharingWithResourceDirectoryStatusRequest) {
	request = &CheckSharingWithResourceDirectoryStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceSharing", "2020-01-10", "CheckSharingWithResourceDirectoryStatus", "ressharing", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCheckSharingWithResourceDirectoryStatusResponse creates a response to parse from CheckSharingWithResourceDirectoryStatus response
func CreateCheckSharingWithResourceDirectoryStatusResponse() (response *CheckSharingWithResourceDirectoryStatusResponse) {
	response = &CheckSharingWithResourceDirectoryStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
