package resourcemanager

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateAssociatedTransferSetting invokes the resourcemanager.UpdateAssociatedTransferSetting API synchronously
func (client *Client) UpdateAssociatedTransferSetting(request *UpdateAssociatedTransferSettingRequest) (response *UpdateAssociatedTransferSettingResponse, err error) {
	response = CreateUpdateAssociatedTransferSettingResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateAssociatedTransferSettingWithChan invokes the resourcemanager.UpdateAssociatedTransferSetting API asynchronously
func (client *Client) UpdateAssociatedTransferSettingWithChan(request *UpdateAssociatedTransferSettingRequest) (<-chan *UpdateAssociatedTransferSettingResponse, <-chan error) {
	responseChan := make(chan *UpdateAssociatedTransferSettingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateAssociatedTransferSetting(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateAssociatedTransferSettingWithCallback invokes the resourcemanager.UpdateAssociatedTransferSetting API asynchronously
func (client *Client) UpdateAssociatedTransferSettingWithCallback(request *UpdateAssociatedTransferSettingRequest, callback func(response *UpdateAssociatedTransferSettingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateAssociatedTransferSettingResponse
		var err error
		defer close(result)
		response, err = client.UpdateAssociatedTransferSetting(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateAssociatedTransferSettingRequest is the request struct for api UpdateAssociatedTransferSetting
type UpdateAssociatedTransferSettingRequest struct {
	*requests.RpcRequest
	RuleSettings                    *[]UpdateAssociatedTransferSettingRuleSettings `position:"Query" name:"RuleSettings"  type:"Repeated"`
	EnableExistingResourcesTransfer string                                         `position:"Query" name:"EnableExistingResourcesTransfer"`
}

// UpdateAssociatedTransferSettingRuleSettings is a repeated param struct in UpdateAssociatedTransferSettingRequest
type UpdateAssociatedTransferSettingRuleSettings struct {
	AssociatedService      string `name:"AssociatedService"`
	MasterService          string `name:"MasterService"`
	MasterResourceType     string `name:"MasterResourceType"`
	AssociatedResourceType string `name:"AssociatedResourceType"`
	RuleId                 string `name:"RuleId"`
	Status                 string `name:"Status"`
}

// UpdateAssociatedTransferSettingResponse is the response struct for api UpdateAssociatedTransferSetting
type UpdateAssociatedTransferSettingResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateAssociatedTransferSettingRequest creates a request to invoke UpdateAssociatedTransferSetting API
func CreateUpdateAssociatedTransferSettingRequest() (request *UpdateAssociatedTransferSettingRequest) {
	request = &UpdateAssociatedTransferSettingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceManager", "2020-03-31", "UpdateAssociatedTransferSetting", "resourcemanager", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateAssociatedTransferSettingResponse creates a response to parse from UpdateAssociatedTransferSetting response
func CreateUpdateAssociatedTransferSettingResponse() (response *UpdateAssociatedTransferSettingResponse) {
	response = &UpdateAssociatedTransferSettingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
