package resourcemanager

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateAutoGroupingRule invokes the resourcemanager.CreateAutoGroupingRule API synchronously
func (client *Client) CreateAutoGroupingRule(request *CreateAutoGroupingRuleRequest) (response *CreateAutoGroupingRuleResponse, err error) {
	response = CreateCreateAutoGroupingRuleResponse()
	err = client.DoAction(request, response)
	return
}

// CreateAutoGroupingRuleWithChan invokes the resourcemanager.CreateAutoGroupingRule API asynchronously
func (client *Client) CreateAutoGroupingRuleWithChan(request *CreateAutoGroupingRuleRequest) (<-chan *CreateAutoGroupingRuleResponse, <-chan error) {
	responseChan := make(chan *CreateAutoGroupingRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateAutoGroupingRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateAutoGroupingRuleWithCallback invokes the resourcemanager.CreateAutoGroupingRule API asynchronously
func (client *Client) CreateAutoGroupingRuleWithCallback(request *CreateAutoGroupingRuleRequest, callback func(response *CreateAutoGroupingRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateAutoGroupingRuleResponse
		var err error
		defer close(result)
		response, err = client.CreateAutoGroupingRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateAutoGroupingRuleRequest is the request struct for api CreateAutoGroupingRule
type CreateAutoGroupingRuleRequest struct {
	*requests.RpcRequest
	RuleDesc                     string                                `position:"Query" name:"RuleDesc"`
	ResourceTypesScope           string                                `position:"Query" name:"ResourceTypesScope"`
	RuleName                     string                                `position:"Query" name:"RuleName"`
	ExcludeResourceGroupIdsScope string                                `position:"Query" name:"ExcludeResourceGroupIdsScope"`
	RegionIdsScope               string                                `position:"Query" name:"RegionIdsScope"`
	ResourceIdsScope             string                                `position:"Query" name:"ResourceIdsScope"`
	RuleContents                 *[]CreateAutoGroupingRuleRuleContents `position:"Query" name:"RuleContents"  type:"Repeated"`
	ExcludeResourceTypesScope    string                                `position:"Query" name:"ExcludeResourceTypesScope"`
	RuleType                     string                                `position:"Query" name:"RuleType"`
	ResourceGroupIdsScope        string                                `position:"Query" name:"ResourceGroupIdsScope"`
	ExcludeRegionIdsScope        string                                `position:"Query" name:"ExcludeRegionIdsScope"`
	ExcludeResourceIdsScope      string                                `position:"Query" name:"ExcludeResourceIdsScope"`
}

// CreateAutoGroupingRuleRuleContents is a repeated param struct in CreateAutoGroupingRuleRequest
type CreateAutoGroupingRuleRuleContents struct {
	TargetResourceGroupCondition string `name:"TargetResourceGroupCondition"`
	AutoGroupingScopeCondition   string `name:"AutoGroupingScopeCondition"`
}

// CreateAutoGroupingRuleResponse is the response struct for api CreateAutoGroupingRule
type CreateAutoGroupingRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	RuleId    string `json:"RuleId" xml:"RuleId"`
}

// CreateCreateAutoGroupingRuleRequest creates a request to invoke CreateAutoGroupingRule API
func CreateCreateAutoGroupingRuleRequest() (request *CreateAutoGroupingRuleRequest) {
	request = &CreateAutoGroupingRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceManager", "2020-03-31", "CreateAutoGroupingRule", "resourcemanager", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateAutoGroupingRuleResponse creates a response to parse from CreateAutoGroupingRule response
func CreateCreateAutoGroupingRuleResponse() (response *CreateAutoGroupingRuleResponse) {
	response = &CreateAutoGroupingRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
