package resourcecenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateSavedQuery invokes the resourcecenter.UpdateSavedQuery API synchronously
func (client *Client) UpdateSavedQuery(request *UpdateSavedQueryRequest) (response *UpdateSavedQueryResponse, err error) {
	response = CreateUpdateSavedQueryResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateSavedQueryWithChan invokes the resourcecenter.UpdateSavedQuery API asynchronously
func (client *Client) UpdateSavedQueryWithChan(request *UpdateSavedQueryRequest) (<-chan *UpdateSavedQueryResponse, <-chan error) {
	responseChan := make(chan *UpdateSavedQueryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateSavedQuery(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateSavedQueryWithCallback invokes the resourcecenter.UpdateSavedQuery API asynchronously
func (client *Client) UpdateSavedQueryWithCallback(request *UpdateSavedQueryRequest, callback func(response *UpdateSavedQueryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateSavedQueryResponse
		var err error
		defer close(result)
		response, err = client.UpdateSavedQuery(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateSavedQueryRequest is the request struct for api UpdateSavedQuery
type UpdateSavedQueryRequest struct {
	*requests.RpcRequest
	Expression  string `position:"Query" name:"Expression"`
	Description string `position:"Query" name:"Description"`
	QueryId     string `position:"Query" name:"QueryId"`
	Name        string `position:"Query" name:"Name"`
}

// UpdateSavedQueryResponse is the response struct for api UpdateSavedQuery
type UpdateSavedQueryResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateSavedQueryRequest creates a request to invoke UpdateSavedQuery API
func CreateUpdateSavedQueryRequest() (request *UpdateSavedQueryRequest) {
	request = &UpdateSavedQueryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceCenter", "2022-12-01", "UpdateSavedQuery", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateSavedQueryResponse creates a response to parse from UpdateSavedQuery response
func CreateUpdateSavedQueryResponse() (response *UpdateSavedQueryResponse) {
	response = &UpdateSavedQueryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
