package resourcecenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetSavedQuery invokes the resourcecenter.GetSavedQuery API synchronously
func (client *Client) GetSavedQuery(request *GetSavedQueryRequest) (response *GetSavedQueryResponse, err error) {
	response = CreateGetSavedQueryResponse()
	err = client.DoAction(request, response)
	return
}

// GetSavedQueryWithChan invokes the resourcecenter.GetSavedQuery API asynchronously
func (client *Client) GetSavedQueryWithChan(request *GetSavedQueryRequest) (<-chan *GetSavedQueryResponse, <-chan error) {
	responseChan := make(chan *GetSavedQueryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetSavedQuery(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetSavedQueryWithCallback invokes the resourcecenter.GetSavedQuery API asynchronously
func (client *Client) GetSavedQueryWithCallback(request *GetSavedQueryRequest, callback func(response *GetSavedQueryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetSavedQueryResponse
		var err error
		defer close(result)
		response, err = client.GetSavedQuery(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetSavedQueryRequest is the request struct for api GetSavedQuery
type GetSavedQueryRequest struct {
	*requests.RpcRequest
	QueryId string `position:"Query" name:"QueryId"`
}

// GetSavedQueryResponse is the response struct for api GetSavedQuery
type GetSavedQueryResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	SavedQuery SavedQuery `json:"SavedQuery" xml:"SavedQuery"`
}

// CreateGetSavedQueryRequest creates a request to invoke GetSavedQuery API
func CreateGetSavedQueryRequest() (request *GetSavedQueryRequest) {
	request = &GetSavedQueryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceCenter", "2022-12-01", "GetSavedQuery", "", "")
	request.Method = requests.POST
	return
}

// CreateGetSavedQueryResponse creates a response to parse from GetSavedQuery response
func CreateGetSavedQueryResponse() (response *GetSavedQueryResponse) {
	response = &GetSavedQueryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
