package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeInstanceKeywords invokes the rds.DescribeInstanceKeywords API synchronously
func (client *Client) DescribeInstanceKeywords(request *DescribeInstanceKeywordsRequest) (response *DescribeInstanceKeywordsResponse, err error) {
	response = CreateDescribeInstanceKeywordsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeInstanceKeywordsWithChan invokes the rds.DescribeInstanceKeywords API asynchronously
func (client *Client) DescribeInstanceKeywordsWithChan(request *DescribeInstanceKeywordsRequest) (<-chan *DescribeInstanceKeywordsResponse, <-chan error) {
	responseChan := make(chan *DescribeInstanceKeywordsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeInstanceKeywords(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeInstanceKeywordsWithCallback invokes the rds.DescribeInstanceKeywords API asynchronously
func (client *Client) DescribeInstanceKeywordsWithCallback(request *DescribeInstanceKeywordsRequest, callback func(response *DescribeInstanceKeywordsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeInstanceKeywordsResponse
		var err error
		defer close(result)
		response, err = client.DescribeInstanceKeywords(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeInstanceKeywordsRequest is the request struct for api DescribeInstanceKeywords
type DescribeInstanceKeywordsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Key                  string           `position:"Query" name:"Key"`
}

// DescribeInstanceKeywordsResponse is the response struct for api DescribeInstanceKeywords
type DescribeInstanceKeywordsResponse struct {
	*responses.BaseResponse
	Key       string `json:"Key" xml:"Key"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Words     Words  `json:"Words" xml:"Words"`
}

// CreateDescribeInstanceKeywordsRequest creates a request to invoke DescribeInstanceKeywords API
func CreateDescribeInstanceKeywordsRequest() (request *DescribeInstanceKeywordsRequest) {
	request = &DescribeInstanceKeywordsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "DescribeInstanceKeywords", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeInstanceKeywordsResponse creates a response to parse from DescribeInstanceKeywords response
func CreateDescribeInstanceKeywordsResponse() (response *DescribeInstanceKeywordsResponse) {
	response = &DescribeInstanceKeywordsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
