package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeHostGroupElasticStrategyParameters invokes the rds.DescribeHostGroupElasticStrategyParameters API synchronously
func (client *Client) DescribeHostGroupElasticStrategyParameters(request *DescribeHostGroupElasticStrategyParametersRequest) (response *DescribeHostGroupElasticStrategyParametersResponse, err error) {
	response = CreateDescribeHostGroupElasticStrategyParametersResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeHostGroupElasticStrategyParametersWithChan invokes the rds.DescribeHostGroupElasticStrategyParameters API asynchronously
func (client *Client) DescribeHostGroupElasticStrategyParametersWithChan(request *DescribeHostGroupElasticStrategyParametersRequest) (<-chan *DescribeHostGroupElasticStrategyParametersResponse, <-chan error) {
	responseChan := make(chan *DescribeHostGroupElasticStrategyParametersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeHostGroupElasticStrategyParameters(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeHostGroupElasticStrategyParametersWithCallback invokes the rds.DescribeHostGroupElasticStrategyParameters API asynchronously
func (client *Client) DescribeHostGroupElasticStrategyParametersWithCallback(request *DescribeHostGroupElasticStrategyParametersRequest, callback func(response *DescribeHostGroupElasticStrategyParametersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeHostGroupElasticStrategyParametersResponse
		var err error
		defer close(result)
		response, err = client.DescribeHostGroupElasticStrategyParameters(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeHostGroupElasticStrategyParametersRequest is the request struct for api DescribeHostGroupElasticStrategyParameters
type DescribeHostGroupElasticStrategyParametersRequest struct {
	*requests.RpcRequest
	ResourceOwnerId        requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount   string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId                requests.Integer `position:"Query" name:"OwnerId"`
	ResourceGroupId        string           `position:"Query" name:"ResourceGroupId"`
	DedicatedHostGroupName string           `position:"Query" name:"DedicatedHostGroupName"`
}

// DescribeHostGroupElasticStrategyParametersResponse is the response struct for api DescribeHostGroupElasticStrategyParameters
type DescribeHostGroupElasticStrategyParametersResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	CpuShar     int    `json:"CpuShar" xml:"CpuShar"`
	IopsZoom    int    `json:"IopsZoom" xml:"IopsZoom"`
	MaxConnZoom int    `json:"MaxConnZoom" xml:"MaxConnZoom"`
	CpuZoom     int    `json:"CpuZoom" xml:"CpuZoom"`
	MemoryZoom  int    `json:"MemoryZoom" xml:"MemoryZoom"`
}

// CreateDescribeHostGroupElasticStrategyParametersRequest creates a request to invoke DescribeHostGroupElasticStrategyParameters API
func CreateDescribeHostGroupElasticStrategyParametersRequest() (request *DescribeHostGroupElasticStrategyParametersRequest) {
	request = &DescribeHostGroupElasticStrategyParametersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "DescribeHostGroupElasticStrategyParameters", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeHostGroupElasticStrategyParametersResponse creates a response to parse from DescribeHostGroupElasticStrategyParameters response
func CreateDescribeHostGroupElasticStrategyParametersResponse() (response *DescribeHostGroupElasticStrategyParametersResponse) {
	response = &DescribeHostGroupElasticStrategyParametersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
