package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteParameterGroup invokes the rds.DeleteParameterGroup API synchronously
func (client *Client) DeleteParameterGroup(request *DeleteParameterGroupRequest) (response *DeleteParameterGroupResponse, err error) {
	response = CreateDeleteParameterGroupResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteParameterGroupWithChan invokes the rds.DeleteParameterGroup API asynchronously
func (client *Client) DeleteParameterGroupWithChan(request *DeleteParameterGroupRequest) (<-chan *DeleteParameterGroupResponse, <-chan error) {
	responseChan := make(chan *DeleteParameterGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteParameterGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteParameterGroupWithCallback invokes the rds.DeleteParameterGroup API asynchronously
func (client *Client) DeleteParameterGroupWithCallback(request *DeleteParameterGroupRequest, callback func(response *DeleteParameterGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteParameterGroupResponse
		var err error
		defer close(result)
		response, err = client.DeleteParameterGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteParameterGroupRequest is the request struct for api DeleteParameterGroup
type DeleteParameterGroupRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceGroupId      string           `position:"Query" name:"ResourceGroupId"`
	ParameterGroupId     string           `position:"Query" name:"ParameterGroupId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteParameterGroupResponse is the response struct for api DeleteParameterGroup
type DeleteParameterGroupResponse struct {
	*responses.BaseResponse
	ParameterGroupId string `json:"ParameterGroupId" xml:"ParameterGroupId"`
	RequestId        string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteParameterGroupRequest creates a request to invoke DeleteParameterGroup API
func CreateDeleteParameterGroupRequest() (request *DeleteParameterGroupRequest) {
	request = &DeleteParameterGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "DeleteParameterGroup", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteParameterGroupResponse creates a response to parse from DeleteParameterGroup response
func CreateDeleteParameterGroupResponse() (response *DeleteParameterGroupResponse) {
	response = &DeleteParameterGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
