package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDBProxyEndpointAddress invokes the rds.DeleteDBProxyEndpointAddress API synchronously
func (client *Client) DeleteDBProxyEndpointAddress(request *DeleteDBProxyEndpointAddressRequest) (response *DeleteDBProxyEndpointAddressResponse, err error) {
	response = CreateDeleteDBProxyEndpointAddressResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDBProxyEndpointAddressWithChan invokes the rds.DeleteDBProxyEndpointAddress API asynchronously
func (client *Client) DeleteDBProxyEndpointAddressWithChan(request *DeleteDBProxyEndpointAddressRequest) (<-chan *DeleteDBProxyEndpointAddressResponse, <-chan error) {
	responseChan := make(chan *DeleteDBProxyEndpointAddressResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDBProxyEndpointAddress(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDBProxyEndpointAddressWithCallback invokes the rds.DeleteDBProxyEndpointAddress API asynchronously
func (client *Client) DeleteDBProxyEndpointAddressWithCallback(request *DeleteDBProxyEndpointAddressRequest, callback func(response *DeleteDBProxyEndpointAddressResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDBProxyEndpointAddressResponse
		var err error
		defer close(result)
		response, err = client.DeleteDBProxyEndpointAddress(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDBProxyEndpointAddressRequest is the request struct for api DeleteDBProxyEndpointAddress
type DeleteDBProxyEndpointAddressRequest struct {
	*requests.RpcRequest
	DBProxyConnectStringNetType string `position:"Query" name:"DBProxyConnectStringNetType"`
	DBInstanceId                string `position:"Query" name:"DBInstanceId"`
	DBProxyEngineType           string `position:"Query" name:"DBProxyEngineType"`
	DBProxyEndpointId           string `position:"Query" name:"DBProxyEndpointId"`
}

// DeleteDBProxyEndpointAddressResponse is the response struct for api DeleteDBProxyEndpointAddress
type DeleteDBProxyEndpointAddressResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteDBProxyEndpointAddressRequest creates a request to invoke DeleteDBProxyEndpointAddress API
func CreateDeleteDBProxyEndpointAddressRequest() (request *DeleteDBProxyEndpointAddressRequest) {
	request = &DeleteDBProxyEndpointAddressRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "DeleteDBProxyEndpointAddress", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteDBProxyEndpointAddressResponse creates a response to parse from DeleteDBProxyEndpointAddress response
func CreateDeleteDBProxyEndpointAddressResponse() (response *DeleteDBProxyEndpointAddressResponse) {
	response = &DeleteDBProxyEndpointAddressResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
