package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDBInstanceForRebuild invokes the rds.CreateDBInstanceForRebuild API synchronously
func (client *Client) CreateDBInstanceForRebuild(request *CreateDBInstanceForRebuildRequest) (response *CreateDBInstanceForRebuildResponse, err error) {
	response = CreateCreateDBInstanceForRebuildResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDBInstanceForRebuildWithChan invokes the rds.CreateDBInstanceForRebuild API asynchronously
func (client *Client) CreateDBInstanceForRebuildWithChan(request *CreateDBInstanceForRebuildRequest) (<-chan *CreateDBInstanceForRebuildResponse, <-chan error) {
	responseChan := make(chan *CreateDBInstanceForRebuildResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDBInstanceForRebuild(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDBInstanceForRebuildWithCallback invokes the rds.CreateDBInstanceForRebuild API asynchronously
func (client *Client) CreateDBInstanceForRebuildWithCallback(request *CreateDBInstanceForRebuildRequest, callback func(response *CreateDBInstanceForRebuildResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDBInstanceForRebuildResponse
		var err error
		defer close(result)
		response, err = client.CreateDBInstanceForRebuild(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDBInstanceForRebuildRequest is the request struct for api CreateDBInstanceForRebuild
type CreateDBInstanceForRebuildRequest struct {
	*requests.RpcRequest
	ResourceOwnerId       requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken           string           `position:"Query" name:"ClientToken"`
	ZoneIdSlave1          string           `position:"Query" name:"ZoneIdSlave1"`
	ZoneIdSlave2          string           `position:"Query" name:"ZoneIdSlave2"`
	ResourceGroupId       string           `position:"Query" name:"ResourceGroupId"`
	SecurityToken         string           `position:"Query" name:"SecurityToken"`
	DBInstanceId          string           `position:"Query" name:"DBInstanceId"`
	DBInstanceDescription string           `position:"Query" name:"DBInstanceDescription"`
	DBInstanceNetType     string           `position:"Query" name:"DBInstanceNetType"`
	Period                string           `position:"Query" name:"Period"`
	ResourceOwnerAccount  string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount          string           `position:"Query" name:"OwnerAccount"`
	OwnerId               requests.Integer `position:"Query" name:"OwnerId"`
	UsedTime              string           `position:"Query" name:"UsedTime"`
	SecurityIPList        string           `position:"Query" name:"SecurityIPList"`
	VSwitchId             string           `position:"Query" name:"VSwitchId"`
	VPCId                 string           `position:"Query" name:"VPCId"`
	ZoneId                string           `position:"Query" name:"ZoneId"`
	PayType               string           `position:"Query" name:"PayType"`
	InstanceNetworkType   string           `position:"Query" name:"InstanceNetworkType"`
}

// CreateDBInstanceForRebuildResponse is the response struct for api CreateDBInstanceForRebuild
type CreateDBInstanceForRebuildResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Message      string `json:"Message" xml:"Message"`
	DBInstanceId string `json:"DBInstanceId" xml:"DBInstanceId"`
	TaskId       string `json:"TaskId" xml:"TaskId"`
	OrderId      string `json:"OrderId" xml:"OrderId"`
}

// CreateCreateDBInstanceForRebuildRequest creates a request to invoke CreateDBInstanceForRebuild API
func CreateCreateDBInstanceForRebuildRequest() (request *CreateDBInstanceForRebuildRequest) {
	request = &CreateDBInstanceForRebuildRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "CreateDBInstanceForRebuild", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateDBInstanceForRebuildResponse creates a response to parse from CreateDBInstanceForRebuild response
func CreateCreateDBInstanceForRebuildResponse() (response *CreateDBInstanceForRebuildResponse) {
	response = &CreateDBInstanceForRebuildResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
