package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ActivateMigrationTargetInstance invokes the rds.ActivateMigrationTargetInstance API synchronously
func (client *Client) ActivateMigrationTargetInstance(request *ActivateMigrationTargetInstanceRequest) (response *ActivateMigrationTargetInstanceResponse, err error) {
	response = CreateActivateMigrationTargetInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// ActivateMigrationTargetInstanceWithChan invokes the rds.ActivateMigrationTargetInstance API asynchronously
func (client *Client) ActivateMigrationTargetInstanceWithChan(request *ActivateMigrationTargetInstanceRequest) (<-chan *ActivateMigrationTargetInstanceResponse, <-chan error) {
	responseChan := make(chan *ActivateMigrationTargetInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ActivateMigrationTargetInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ActivateMigrationTargetInstanceWithCallback invokes the rds.ActivateMigrationTargetInstance API asynchronously
func (client *Client) ActivateMigrationTargetInstanceWithCallback(request *ActivateMigrationTargetInstanceRequest, callback func(response *ActivateMigrationTargetInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ActivateMigrationTargetInstanceResponse
		var err error
		defer close(result)
		response, err = client.ActivateMigrationTargetInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ActivateMigrationTargetInstanceRequest is the request struct for api ActivateMigrationTargetInstance
type ActivateMigrationTargetInstanceRequest struct {
	*requests.RpcRequest
	DBInstanceName       string           `position:"Query" name:"DBInstanceName"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ForceSwitch          string           `position:"Query" name:"ForceSwitch"`
	SwitchTimeMode       string           `position:"Query" name:"SwitchTimeMode"`
	SwitchTime           string           `position:"Query" name:"SwitchTime"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// ActivateMigrationTargetInstanceResponse is the response struct for api ActivateMigrationTargetInstance
type ActivateMigrationTargetInstanceResponse struct {
	*responses.BaseResponse
	DBInstanceName  string `json:"DBInstanceName" xml:"DBInstanceName"`
	RequestId       string `json:"RequestId" xml:"RequestId"`
	TaskId          int64  `json:"TaskId" xml:"TaskId"`
	SourceIpAddress string `json:"SourceIpAddress" xml:"SourceIpAddress"`
	SourcePort      int64  `json:"SourcePort" xml:"SourcePort"`
}

// CreateActivateMigrationTargetInstanceRequest creates a request to invoke ActivateMigrationTargetInstance API
func CreateActivateMigrationTargetInstanceRequest() (request *ActivateMigrationTargetInstanceRequest) {
	request = &ActivateMigrationTargetInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "ActivateMigrationTargetInstance", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateActivateMigrationTargetInstanceResponse creates a response to parse from ActivateMigrationTargetInstance response
func CreateActivateMigrationTargetInstanceResponse() (response *ActivateMigrationTargetInstanceResponse) {
	response = &ActivateMigrationTargetInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
