package r_kvstore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeTairKVCacheCustomInstanceHistoryMonitorValues invokes the r_kvstore.DescribeTairKVCacheCustomInstanceHistoryMonitorValues API synchronously
func (client *Client) DescribeTairKVCacheCustomInstanceHistoryMonitorValues(request *DescribeTairKVCacheCustomInstanceHistoryMonitorValuesRequest) (response *DescribeTairKVCacheCustomInstanceHistoryMonitorValuesResponse, err error) {
	response = CreateDescribeTairKVCacheCustomInstanceHistoryMonitorValuesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeTairKVCacheCustomInstanceHistoryMonitorValuesWithChan invokes the r_kvstore.DescribeTairKVCacheCustomInstanceHistoryMonitorValues API asynchronously
func (client *Client) DescribeTairKVCacheCustomInstanceHistoryMonitorValuesWithChan(request *DescribeTairKVCacheCustomInstanceHistoryMonitorValuesRequest) (<-chan *DescribeTairKVCacheCustomInstanceHistoryMonitorValuesResponse, <-chan error) {
	responseChan := make(chan *DescribeTairKVCacheCustomInstanceHistoryMonitorValuesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeTairKVCacheCustomInstanceHistoryMonitorValues(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeTairKVCacheCustomInstanceHistoryMonitorValuesWithCallback invokes the r_kvstore.DescribeTairKVCacheCustomInstanceHistoryMonitorValues API asynchronously
func (client *Client) DescribeTairKVCacheCustomInstanceHistoryMonitorValuesWithCallback(request *DescribeTairKVCacheCustomInstanceHistoryMonitorValuesRequest, callback func(response *DescribeTairKVCacheCustomInstanceHistoryMonitorValuesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeTairKVCacheCustomInstanceHistoryMonitorValuesResponse
		var err error
		defer close(result)
		response, err = client.DescribeTairKVCacheCustomInstanceHistoryMonitorValues(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeTairKVCacheCustomInstanceHistoryMonitorValuesRequest is the request struct for api DescribeTairKVCacheCustomInstanceHistoryMonitorValues
type DescribeTairKVCacheCustomInstanceHistoryMonitorValuesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Express              string           `position:"Query" name:"Express"`
	StartTime            string           `position:"Query" name:"StartTime"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	MetricName           string           `position:"Query" name:"MetricName"`
	Period               string           `position:"Query" name:"Period"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	Length               string           `position:"Query" name:"Length"`
	EndTime              string           `position:"Query" name:"EndTime"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
	Category             string           `position:"Query" name:"Category"`
}

// DescribeTairKVCacheCustomInstanceHistoryMonitorValuesResponse is the response struct for api DescribeTairKVCacheCustomInstanceHistoryMonitorValues
type DescribeTairKVCacheCustomInstanceHistoryMonitorValuesResponse struct {
	*responses.BaseResponse
	Datapoints string `json:"Datapoints" xml:"Datapoints"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
	NextToken  string `json:"NextToken" xml:"NextToken"`
	Period     string `json:"Period" xml:"Period"`
}

// CreateDescribeTairKVCacheCustomInstanceHistoryMonitorValuesRequest creates a request to invoke DescribeTairKVCacheCustomInstanceHistoryMonitorValues API
func CreateDescribeTairKVCacheCustomInstanceHistoryMonitorValuesRequest() (request *DescribeTairKVCacheCustomInstanceHistoryMonitorValuesRequest) {
	request = &DescribeTairKVCacheCustomInstanceHistoryMonitorValuesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("R-kvstore", "2015-01-01", "DescribeTairKVCacheCustomInstanceHistoryMonitorValues", "redisa", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeTairKVCacheCustomInstanceHistoryMonitorValuesResponse creates a response to parse from DescribeTairKVCacheCustomInstanceHistoryMonitorValues response
func CreateDescribeTairKVCacheCustomInstanceHistoryMonitorValuesResponse() (response *DescribeTairKVCacheCustomInstanceHistoryMonitorValuesResponse) {
	response = &DescribeTairKVCacheCustomInstanceHistoryMonitorValuesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
