package r_kvstore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAuditLogConfig invokes the r_kvstore.DescribeAuditLogConfig API synchronously
func (client *Client) DescribeAuditLogConfig(request *DescribeAuditLogConfigRequest) (response *DescribeAuditLogConfigResponse, err error) {
	response = CreateDescribeAuditLogConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAuditLogConfigWithChan invokes the r_kvstore.DescribeAuditLogConfig API asynchronously
func (client *Client) DescribeAuditLogConfigWithChan(request *DescribeAuditLogConfigRequest) (<-chan *DescribeAuditLogConfigResponse, <-chan error) {
	responseChan := make(chan *DescribeAuditLogConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAuditLogConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAuditLogConfigWithCallback invokes the r_kvstore.DescribeAuditLogConfig API asynchronously
func (client *Client) DescribeAuditLogConfigWithCallback(request *DescribeAuditLogConfigRequest, callback func(response *DescribeAuditLogConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAuditLogConfigResponse
		var err error
		defer close(result)
		response, err = client.DescribeAuditLogConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAuditLogConfigRequest is the request struct for api DescribeAuditLogConfig
type DescribeAuditLogConfigRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
}

// DescribeAuditLogConfigResponse is the response struct for api DescribeAuditLogConfig
type DescribeAuditLogConfigResponse struct {
	*responses.BaseResponse
	Retention string `json:"Retention" xml:"Retention"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	DbAudit   string `json:"DbAudit" xml:"DbAudit"`
}

// CreateDescribeAuditLogConfigRequest creates a request to invoke DescribeAuditLogConfig API
func CreateDescribeAuditLogConfigRequest() (request *DescribeAuditLogConfigRequest) {
	request = &DescribeAuditLogConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("R-kvstore", "2015-01-01", "DescribeAuditLogConfig", "redisa", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeAuditLogConfigResponse creates a response to parse from DescribeAuditLogConfig response
func CreateDescribeAuditLogConfigResponse() (response *DescribeAuditLogConfigResponse) {
	response = &DescribeAuditLogConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
