package quotas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyQuotaTemplateServiceStatus invokes the quotas.ModifyQuotaTemplateServiceStatus API synchronously
func (client *Client) ModifyQuotaTemplateServiceStatus(request *ModifyQuotaTemplateServiceStatusRequest) (response *ModifyQuotaTemplateServiceStatusResponse, err error) {
	response = CreateModifyQuotaTemplateServiceStatusResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyQuotaTemplateServiceStatusWithChan invokes the quotas.ModifyQuotaTemplateServiceStatus API asynchronously
func (client *Client) ModifyQuotaTemplateServiceStatusWithChan(request *ModifyQuotaTemplateServiceStatusRequest) (<-chan *ModifyQuotaTemplateServiceStatusResponse, <-chan error) {
	responseChan := make(chan *ModifyQuotaTemplateServiceStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyQuotaTemplateServiceStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyQuotaTemplateServiceStatusWithCallback invokes the quotas.ModifyQuotaTemplateServiceStatus API asynchronously
func (client *Client) ModifyQuotaTemplateServiceStatusWithCallback(request *ModifyQuotaTemplateServiceStatusRequest, callback func(response *ModifyQuotaTemplateServiceStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyQuotaTemplateServiceStatusResponse
		var err error
		defer close(result)
		response, err = client.ModifyQuotaTemplateServiceStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyQuotaTemplateServiceStatusRequest is the request struct for api ModifyQuotaTemplateServiceStatus
type ModifyQuotaTemplateServiceStatusRequest struct {
	*requests.RpcRequest
	OriginalContext string           `position:"Body" name:"OriginalContext"`
	ServiceStatus   requests.Integer `position:"Body" name:"ServiceStatus"`
}

// ModifyQuotaTemplateServiceStatusResponse is the response struct for api ModifyQuotaTemplateServiceStatus
type ModifyQuotaTemplateServiceStatusResponse struct {
	*responses.BaseResponse
	RequestId             string                `json:"RequestId" xml:"RequestId"`
	TemplateServiceStatus TemplateServiceStatus `json:"TemplateServiceStatus" xml:"TemplateServiceStatus"`
}

// CreateModifyQuotaTemplateServiceStatusRequest creates a request to invoke ModifyQuotaTemplateServiceStatus API
func CreateModifyQuotaTemplateServiceStatusRequest() (request *ModifyQuotaTemplateServiceStatusRequest) {
	request = &ModifyQuotaTemplateServiceStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quotas", "2020-05-10", "ModifyQuotaTemplateServiceStatus", "quotas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyQuotaTemplateServiceStatusResponse creates a response to parse from ModifyQuotaTemplateServiceStatus response
func CreateModifyQuotaTemplateServiceStatusResponse() (response *ModifyQuotaTemplateServiceStatusResponse) {
	response = &ModifyQuotaTemplateServiceStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
