package quickbi_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryApprovalInfo invokes the quickbi_public.QueryApprovalInfo API synchronously
func (client *Client) QueryApprovalInfo(request *QueryApprovalInfoRequest) (response *QueryApprovalInfoResponse, err error) {
	response = CreateQueryApprovalInfoResponse()
	err = client.DoAction(request, response)
	return
}

// QueryApprovalInfoWithChan invokes the quickbi_public.QueryApprovalInfo API asynchronously
func (client *Client) QueryApprovalInfoWithChan(request *QueryApprovalInfoRequest) (<-chan *QueryApprovalInfoResponse, <-chan error) {
	responseChan := make(chan *QueryApprovalInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryApprovalInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryApprovalInfoWithCallback invokes the quickbi_public.QueryApprovalInfo API asynchronously
func (client *Client) QueryApprovalInfoWithCallback(request *QueryApprovalInfoRequest, callback func(response *QueryApprovalInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryApprovalInfoResponse
		var err error
		defer close(result)
		response, err = client.QueryApprovalInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryApprovalInfoRequest is the request struct for api QueryApprovalInfo
type QueryApprovalInfoRequest struct {
	*requests.RpcRequest
	AccessPoint string           `position:"Query" name:"AccessPoint"`
	UserId      string           `position:"Query" name:"UserId"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	SignType    string           `position:"Query" name:"SignType"`
	Page        requests.Integer `position:"Query" name:"Page"`
	Status      requests.Integer `position:"Query" name:"Status"`
}

// QueryApprovalInfoResponse is the response struct for api QueryApprovalInfo
type QueryApprovalInfoResponse struct {
	*responses.BaseResponse
	RequestId string                    `json:"RequestId" xml:"RequestId"`
	Success   bool                      `json:"Success" xml:"Success"`
	Result    ResultInQueryApprovalInfo `json:"Result" xml:"Result"`
}

// CreateQueryApprovalInfoRequest creates a request to invoke QueryApprovalInfo API
func CreateQueryApprovalInfoRequest() (request *QueryApprovalInfoRequest) {
	request = &QueryApprovalInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quickbi-public", "2022-01-01", "QueryApprovalInfo", "2.2.0", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryApprovalInfoResponse creates a response to parse from QueryApprovalInfo response
func CreateQueryApprovalInfoResponse() (response *QueryApprovalInfoResponse) {
	response = &QueryApprovalInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
