package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetWarningStrategyConfig invokes the qualitycheck.GetWarningStrategyConfig API synchronously
func (client *Client) GetWarningStrategyConfig(request *GetWarningStrategyConfigRequest) (response *GetWarningStrategyConfigResponse, err error) {
	response = CreateGetWarningStrategyConfigResponse()
	err = client.DoAction(request, response)
	return
}

// GetWarningStrategyConfigWithChan invokes the qualitycheck.GetWarningStrategyConfig API asynchronously
func (client *Client) GetWarningStrategyConfigWithChan(request *GetWarningStrategyConfigRequest) (<-chan *GetWarningStrategyConfigResponse, <-chan error) {
	responseChan := make(chan *GetWarningStrategyConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetWarningStrategyConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetWarningStrategyConfigWithCallback invokes the qualitycheck.GetWarningStrategyConfig API asynchronously
func (client *Client) GetWarningStrategyConfigWithCallback(request *GetWarningStrategyConfigRequest, callback func(response *GetWarningStrategyConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetWarningStrategyConfigResponse
		var err error
		defer close(result)
		response, err = client.GetWarningStrategyConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetWarningStrategyConfigRequest is the request struct for api GetWarningStrategyConfig
type GetWarningStrategyConfigRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	JsonStr         string           `position:"Query" name:"JsonStr"`
	BaseMeAgentId   requests.Integer `position:"Query" name:"BaseMeAgentId"`
}

// GetWarningStrategyConfigResponse is the response struct for api GetWarningStrategyConfig
type GetWarningStrategyConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetWarningStrategyConfigRequest creates a request to invoke GetWarningStrategyConfig API
func CreateGetWarningStrategyConfigRequest() (request *GetWarningStrategyConfigRequest) {
	request = &GetWarningStrategyConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "GetWarningStrategyConfig", "", "")
	request.Method = requests.POST
	return
}

// CreateGetWarningStrategyConfigResponse creates a response to parse from GetWarningStrategyConfig response
func CreateGetWarningStrategyConfigResponse() (response *GetWarningStrategyConfigResponse) {
	response = &GetWarningStrategyConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
