package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetQualityCheckScheme invokes the qualitycheck.GetQualityCheckScheme API synchronously
func (client *Client) GetQualityCheckScheme(request *GetQualityCheckSchemeRequest) (response *GetQualityCheckSchemeResponse, err error) {
	response = CreateGetQualityCheckSchemeResponse()
	err = client.DoAction(request, response)
	return
}

// GetQualityCheckSchemeWithChan invokes the qualitycheck.GetQualityCheckScheme API asynchronously
func (client *Client) GetQualityCheckSchemeWithChan(request *GetQualityCheckSchemeRequest) (<-chan *GetQualityCheckSchemeResponse, <-chan error) {
	responseChan := make(chan *GetQualityCheckSchemeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetQualityCheckScheme(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetQualityCheckSchemeWithCallback invokes the qualitycheck.GetQualityCheckScheme API asynchronously
func (client *Client) GetQualityCheckSchemeWithCallback(request *GetQualityCheckSchemeRequest, callback func(response *GetQualityCheckSchemeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetQualityCheckSchemeResponse
		var err error
		defer close(result)
		response, err = client.GetQualityCheckScheme(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetQualityCheckSchemeRequest is the request struct for api GetQualityCheckScheme
type GetQualityCheckSchemeRequest struct {
	*requests.RpcRequest
	JsonStr       string           `position:"Query" name:"jsonStr"`
	BaseMeAgentId requests.Integer `position:"Query" name:"BaseMeAgentId"`
}

// GetQualityCheckSchemeResponse is the response struct for api GetQualityCheckScheme
type GetQualityCheckSchemeResponse struct {
	*responses.BaseResponse
}

// CreateGetQualityCheckSchemeRequest creates a request to invoke GetQualityCheckScheme API
func CreateGetQualityCheckSchemeRequest() (request *GetQualityCheckSchemeRequest) {
	request = &GetQualityCheckSchemeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "GetQualityCheckScheme", "", "")
	request.Method = requests.POST
	return
}

// CreateGetQualityCheckSchemeResponse creates a response to parse from GetQualityCheckScheme response
func CreateGetQualityCheckSchemeResponse() (response *GetQualityCheckSchemeResponse) {
	response = &GetQualityCheckSchemeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
