package qianzhou

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// Hello invokes the qianzhou.Hello API synchronously
func (client *Client) Hello(request *HelloRequest) (response *HelloResponse, err error) {
	response = CreateHelloResponse()
	err = client.DoAction(request, response)
	return
}

// HelloWithChan invokes the qianzhou.Hello API asynchronously
func (client *Client) HelloWithChan(request *HelloRequest) (<-chan *HelloResponse, <-chan error) {
	responseChan := make(chan *HelloResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.Hello(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// HelloWithCallback invokes the qianzhou.Hello API asynchronously
func (client *Client) HelloWithCallback(request *HelloRequest, callback func(response *HelloResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *HelloResponse
		var err error
		defer close(result)
		response, err = client.Hello(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// HelloRequest is the request struct for api Hello
type HelloRequest struct {
	*requests.RoaRequest
	User string `position:"Query" name:"user"`
}

// HelloResponse is the response struct for api Hello
type HelloResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
	Code      string `json:"code" xml:"code"`
	Msg       string `json:"msg" xml:"msg"`
	Data      Data   `json:"data" xml:"data"`
}

// CreateHelloRequest creates a request to invoke Hello API
func CreateHelloRequest() (request *HelloRequest) {
	request = &HelloRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("qianzhou", "2021-11-11", "Hello", "/popapi/hello", "", "")
	request.Method = requests.GET
	return
}

// CreateHelloResponse creates a response to parse from Hello response
func CreateHelloResponse() (response *HelloResponse) {
	response = &HelloResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
