package pts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetPtsSceneBaseLine invokes the pts.GetPtsSceneBaseLine API synchronously
func (client *Client) GetPtsSceneBaseLine(request *GetPtsSceneBaseLineRequest) (response *GetPtsSceneBaseLineResponse, err error) {
	response = CreateGetPtsSceneBaseLineResponse()
	err = client.DoAction(request, response)
	return
}

// GetPtsSceneBaseLineWithChan invokes the pts.GetPtsSceneBaseLine API asynchronously
func (client *Client) GetPtsSceneBaseLineWithChan(request *GetPtsSceneBaseLineRequest) (<-chan *GetPtsSceneBaseLineResponse, <-chan error) {
	responseChan := make(chan *GetPtsSceneBaseLineResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetPtsSceneBaseLine(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetPtsSceneBaseLineWithCallback invokes the pts.GetPtsSceneBaseLine API asynchronously
func (client *Client) GetPtsSceneBaseLineWithCallback(request *GetPtsSceneBaseLineRequest, callback func(response *GetPtsSceneBaseLineResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetPtsSceneBaseLineResponse
		var err error
		defer close(result)
		response, err = client.GetPtsSceneBaseLine(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetPtsSceneBaseLineRequest is the request struct for api GetPtsSceneBaseLine
type GetPtsSceneBaseLineRequest struct {
	*requests.RpcRequest
	SceneId string `position:"Query" name:"SceneId"`
}

// GetPtsSceneBaseLineResponse is the response struct for api GetPtsSceneBaseLine
type GetPtsSceneBaseLineResponse struct {
	*responses.BaseResponse
	SceneId        string   `json:"SceneId" xml:"SceneId"`
	RequestId      string   `json:"RequestId" xml:"RequestId"`
	Message        string   `json:"Message" xml:"Message"`
	HttpStatusCode int      `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string   `json:"Code" xml:"Code"`
	Success        bool     `json:"Success" xml:"Success"`
	Baseline       Baseline `json:"Baseline" xml:"Baseline"`
}

// CreateGetPtsSceneBaseLineRequest creates a request to invoke GetPtsSceneBaseLine API
func CreateGetPtsSceneBaseLineRequest() (request *GetPtsSceneBaseLineRequest) {
	request = &GetPtsSceneBaseLineRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("PTS", "2020-10-20", "GetPtsSceneBaseLine", "", "")
	request.Method = requests.POST
	return
}

// CreateGetPtsSceneBaseLineResponse creates a response to parse from GetPtsSceneBaseLine response
func CreateGetPtsSceneBaseLineResponse() (response *GetPtsSceneBaseLineResponse) {
	response = &GetPtsSceneBaseLineResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
