package pts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetPtsReportDetails invokes the pts.GetPtsReportDetails API synchronously
func (client *Client) GetPtsReportDetails(request *GetPtsReportDetailsRequest) (response *GetPtsReportDetailsResponse, err error) {
	response = CreateGetPtsReportDetailsResponse()
	err = client.DoAction(request, response)
	return
}

// GetPtsReportDetailsWithChan invokes the pts.GetPtsReportDetails API asynchronously
func (client *Client) GetPtsReportDetailsWithChan(request *GetPtsReportDetailsRequest) (<-chan *GetPtsReportDetailsResponse, <-chan error) {
	responseChan := make(chan *GetPtsReportDetailsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetPtsReportDetails(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetPtsReportDetailsWithCallback invokes the pts.GetPtsReportDetails API asynchronously
func (client *Client) GetPtsReportDetailsWithCallback(request *GetPtsReportDetailsRequest, callback func(response *GetPtsReportDetailsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetPtsReportDetailsResponse
		var err error
		defer close(result)
		response, err = client.GetPtsReportDetails(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetPtsReportDetailsRequest is the request struct for api GetPtsReportDetails
type GetPtsReportDetailsRequest struct {
	*requests.RpcRequest
	SceneId string `position:"Query" name:"SceneId"`
	PlanId  string `position:"Query" name:"PlanId"`
}

// GetPtsReportDetailsResponse is the response struct for api GetPtsReportDetails
type GetPtsReportDetailsResponse struct {
	*responses.BaseResponse
	Message        string         `json:"Message" xml:"Message"`
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int            `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string         `json:"Code" xml:"Code"`
	Success        bool           `json:"Success" xml:"Success"`
	ReportOverView ReportOverView `json:"ReportOverView" xml:"ReportOverView"`
	SceneMetrics   SceneMetrics   `json:"SceneMetrics" xml:"SceneMetrics"`
	SceneSnapShot  SceneSnapShot  `json:"SceneSnapShot" xml:"SceneSnapShot"`
	ApiMetricsList []ApiMetrics   `json:"ApiMetricsList" xml:"ApiMetricsList"`
}

// CreateGetPtsReportDetailsRequest creates a request to invoke GetPtsReportDetails API
func CreateGetPtsReportDetailsRequest() (request *GetPtsReportDetailsRequest) {
	request = &GetPtsReportDetailsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("PTS", "2020-10-20", "GetPtsReportDetails", "", "")
	request.Method = requests.POST
	return
}

// CreateGetPtsReportDetailsResponse creates a response to parse from GetPtsReportDetails response
func CreateGetPtsReportDetailsResponse() (response *GetPtsReportDetailsResponse) {
	response = &GetPtsReportDetailsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
