package polardb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDBClusterConnectivity invokes the polardb.DescribeDBClusterConnectivity API synchronously
func (client *Client) DescribeDBClusterConnectivity(request *DescribeDBClusterConnectivityRequest) (response *DescribeDBClusterConnectivityResponse, err error) {
	response = CreateDescribeDBClusterConnectivityResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDBClusterConnectivityWithChan invokes the polardb.DescribeDBClusterConnectivity API asynchronously
func (client *Client) DescribeDBClusterConnectivityWithChan(request *DescribeDBClusterConnectivityRequest) (<-chan *DescribeDBClusterConnectivityResponse, <-chan error) {
	responseChan := make(chan *DescribeDBClusterConnectivityResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDBClusterConnectivity(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDBClusterConnectivityWithCallback invokes the polardb.DescribeDBClusterConnectivity API asynchronously
func (client *Client) DescribeDBClusterConnectivityWithCallback(request *DescribeDBClusterConnectivityRequest, callback func(response *DescribeDBClusterConnectivityResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDBClusterConnectivityResponse
		var err error
		defer close(result)
		response, err = client.DescribeDBClusterConnectivity(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDBClusterConnectivityRequest is the request struct for api DescribeDBClusterConnectivity
type DescribeDBClusterConnectivityRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceGroupId      string           `position:"Query" name:"ResourceGroupId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	SourceIpAddress      string           `position:"Query" name:"SourceIpAddress"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeDBClusterConnectivityResponse is the response struct for api DescribeDBClusterConnectivity
type DescribeDBClusterConnectivityResponse struct {
	*responses.BaseResponse
	RequestId             string `json:"RequestId" xml:"RequestId"`
	DBClusterId           string `json:"DBClusterId" xml:"DBClusterId"`
	ConnCheckResult       string `json:"ConnCheckResult" xml:"ConnCheckResult"`
	ConnCheckErrorCode    string `json:"ConnCheckErrorCode" xml:"ConnCheckErrorCode"`
	ConnCheckErrorMessage string `json:"ConnCheckErrorMessage" xml:"ConnCheckErrorMessage"`
}

// CreateDescribeDBClusterConnectivityRequest creates a request to invoke DescribeDBClusterConnectivity API
func CreateDescribeDBClusterConnectivityRequest() (request *DescribeDBClusterConnectivityRequest) {
	request = &DescribeDBClusterConnectivityRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardb", "2017-08-01", "DescribeDBClusterConnectivity", "polardb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDBClusterConnectivityResponse creates a response to parse from DescribeDBClusterConnectivity response
func CreateDescribeDBClusterConnectivityResponse() (response *DescribeDBClusterConnectivityResponse) {
	response = &DescribeDBClusterConnectivityResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
