package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateResourceRule invokes the pairecservice.UpdateResourceRule API synchronously
func (client *Client) UpdateResourceRule(request *UpdateResourceRuleRequest) (response *UpdateResourceRuleResponse, err error) {
	response = CreateUpdateResourceRuleResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateResourceRuleWithChan invokes the pairecservice.UpdateResourceRule API asynchronously
func (client *Client) UpdateResourceRuleWithChan(request *UpdateResourceRuleRequest) (<-chan *UpdateResourceRuleResponse, <-chan error) {
	responseChan := make(chan *UpdateResourceRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateResourceRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateResourceRuleWithCallback invokes the pairecservice.UpdateResourceRule API asynchronously
func (client *Client) UpdateResourceRuleWithCallback(request *UpdateResourceRuleRequest, callback func(response *UpdateResourceRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateResourceRuleResponse
		var err error
		defer close(result)
		response, err = client.UpdateResourceRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateResourceRuleRequest is the request struct for api UpdateResourceRule
type UpdateResourceRuleRequest struct {
	*requests.RoaRequest
	Body           string `position:"Body" name:"body"`
	ResourceRuleId string `position:"Path" name:"ResourceRuleId"`
}

// UpdateResourceRuleResponse is the response struct for api UpdateResourceRule
type UpdateResourceRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateResourceRuleRequest creates a request to invoke UpdateResourceRule API
func CreateUpdateResourceRuleRequest() (request *UpdateResourceRuleRequest) {
	request = &UpdateResourceRuleRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "UpdateResourceRule", "/api/v1/resourcerules/[ResourceRuleId]", "", "")
	request.Method = requests.PUT
	return
}

// CreateUpdateResourceRuleResponse creates a response to parse from UpdateResourceRule response
func CreateUpdateResourceRuleResponse() (response *UpdateResourceRuleResponse) {
	response = &UpdateResourceRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
