package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListSampleConsistencyJobs invokes the pairecservice.ListSampleConsistencyJobs API synchronously
func (client *Client) ListSampleConsistencyJobs(request *ListSampleConsistencyJobsRequest) (response *ListSampleConsistencyJobsResponse, err error) {
	response = CreateListSampleConsistencyJobsResponse()
	err = client.DoAction(request, response)
	return
}

// ListSampleConsistencyJobsWithChan invokes the pairecservice.ListSampleConsistencyJobs API asynchronously
func (client *Client) ListSampleConsistencyJobsWithChan(request *ListSampleConsistencyJobsRequest) (<-chan *ListSampleConsistencyJobsResponse, <-chan error) {
	responseChan := make(chan *ListSampleConsistencyJobsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListSampleConsistencyJobs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListSampleConsistencyJobsWithCallback invokes the pairecservice.ListSampleConsistencyJobs API asynchronously
func (client *Client) ListSampleConsistencyJobsWithCallback(request *ListSampleConsistencyJobsRequest, callback func(response *ListSampleConsistencyJobsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListSampleConsistencyJobsResponse
		var err error
		defer close(result)
		response, err = client.ListSampleConsistencyJobs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListSampleConsistencyJobsRequest is the request struct for api ListSampleConsistencyJobs
type ListSampleConsistencyJobsRequest struct {
	*requests.RoaRequest
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	InstanceId string           `position:"Query" name:"InstanceId"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	SortBy     string           `position:"Query" name:"SortBy"`
	Order      string           `position:"Query" name:"Order"`
}

// ListSampleConsistencyJobsResponse is the response struct for api ListSampleConsistencyJobs
type ListSampleConsistencyJobsResponse struct {
	*responses.BaseResponse
	RequestId             string                      `json:"RequestId" xml:"RequestId"`
	TotalCount            int64                       `json:"TotalCount" xml:"TotalCount"`
	SampleConsistencyJobs []SampleConsistencyJobsItem `json:"SampleConsistencyJobs" xml:"SampleConsistencyJobs"`
}

// CreateListSampleConsistencyJobsRequest creates a request to invoke ListSampleConsistencyJobs API
func CreateListSampleConsistencyJobsRequest() (request *ListSampleConsistencyJobsRequest) {
	request = &ListSampleConsistencyJobsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "ListSampleConsistencyJobs", "/api/v1/sampleconsistencyjobs", "", "")
	request.Method = requests.GET
	return
}

// CreateListSampleConsistencyJobsResponse creates a response to parse from ListSampleConsistencyJobs response
func CreateListSampleConsistencyJobsResponse() (response *ListSampleConsistencyJobsResponse) {
	response = &ListSampleConsistencyJobsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
