package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListEngineConfigs invokes the pairecservice.ListEngineConfigs API synchronously
func (client *Client) ListEngineConfigs(request *ListEngineConfigsRequest) (response *ListEngineConfigsResponse, err error) {
	response = CreateListEngineConfigsResponse()
	err = client.DoAction(request, response)
	return
}

// ListEngineConfigsWithChan invokes the pairecservice.ListEngineConfigs API asynchronously
func (client *Client) ListEngineConfigsWithChan(request *ListEngineConfigsRequest) (<-chan *ListEngineConfigsResponse, <-chan error) {
	responseChan := make(chan *ListEngineConfigsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListEngineConfigs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListEngineConfigsWithCallback invokes the pairecservice.ListEngineConfigs API asynchronously
func (client *Client) ListEngineConfigsWithCallback(request *ListEngineConfigsRequest, callback func(response *ListEngineConfigsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListEngineConfigsResponse
		var err error
		defer close(result)
		response, err = client.ListEngineConfigs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListEngineConfigsRequest is the request struct for api ListEngineConfigs
type ListEngineConfigsRequest struct {
	*requests.RoaRequest
	Environment string           `position:"Query" name:"Environment"`
	InstanceId  string           `position:"Query" name:"InstanceId"`
	Name        string           `position:"Query" name:"Name"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	Version     string           `position:"Query" name:"Version"`
	PageNumber  requests.Integer `position:"Query" name:"PageNumber"`
	Status      string           `position:"Query" name:"Status"`
}

// ListEngineConfigsResponse is the response struct for api ListEngineConfigs
type ListEngineConfigsResponse struct {
	*responses.BaseResponse
	RequestId     string              `json:"RequestId" xml:"RequestId"`
	TotalCount    int64               `json:"TotalCount" xml:"TotalCount"`
	EngineConfigs []EngineConfigsItem `json:"EngineConfigs" xml:"EngineConfigs"`
}

// CreateListEngineConfigsRequest creates a request to invoke ListEngineConfigs API
func CreateListEngineConfigsRequest() (request *ListEngineConfigsRequest) {
	request = &ListEngineConfigsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "ListEngineConfigs", "/api/v1/engineconfigs", "", "")
	request.Method = requests.GET
	return
}

// CreateListEngineConfigsResponse creates a response to parse from ListEngineConfigs response
func CreateListEngineConfigsResponse() (response *ListEngineConfigsResponse) {
	response = &ListEngineConfigsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
