package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetFeatureConsistencyCheckJob invokes the pairecservice.GetFeatureConsistencyCheckJob API synchronously
func (client *Client) GetFeatureConsistencyCheckJob(request *GetFeatureConsistencyCheckJobRequest) (response *GetFeatureConsistencyCheckJobResponse, err error) {
	response = CreateGetFeatureConsistencyCheckJobResponse()
	err = client.DoAction(request, response)
	return
}

// GetFeatureConsistencyCheckJobWithChan invokes the pairecservice.GetFeatureConsistencyCheckJob API asynchronously
func (client *Client) GetFeatureConsistencyCheckJobWithChan(request *GetFeatureConsistencyCheckJobRequest) (<-chan *GetFeatureConsistencyCheckJobResponse, <-chan error) {
	responseChan := make(chan *GetFeatureConsistencyCheckJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetFeatureConsistencyCheckJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetFeatureConsistencyCheckJobWithCallback invokes the pairecservice.GetFeatureConsistencyCheckJob API asynchronously
func (client *Client) GetFeatureConsistencyCheckJobWithCallback(request *GetFeatureConsistencyCheckJobRequest, callback func(response *GetFeatureConsistencyCheckJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetFeatureConsistencyCheckJobResponse
		var err error
		defer close(result)
		response, err = client.GetFeatureConsistencyCheckJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetFeatureConsistencyCheckJobRequest is the request struct for api GetFeatureConsistencyCheckJob
type GetFeatureConsistencyCheckJobRequest struct {
	*requests.RoaRequest
	InstanceId                   string `position:"Query" name:"InstanceId"`
	FeatureConsistencyCheckJobId string `position:"Path" name:"FeatureConsistencyCheckJobId"`
}

// GetFeatureConsistencyCheckJobResponse is the response struct for api GetFeatureConsistencyCheckJob
type GetFeatureConsistencyCheckJobResponse struct {
	*responses.BaseResponse
	RequestId                            string   `json:"RequestId" xml:"RequestId"`
	FeatureConsistencyCheckJobConfigId   string   `json:"FeatureConsistencyCheckJobConfigId" xml:"FeatureConsistencyCheckJobConfigId"`
	FeatureConsistencyCheckJobConfigName string   `json:"FeatureConsistencyCheckJobConfigName" xml:"FeatureConsistencyCheckJobConfigName"`
	GmtStartTime                         string   `json:"GmtStartTime" xml:"GmtStartTime"`
	GmtEndTime                           string   `json:"GmtEndTime" xml:"GmtEndTime"`
	Status                               string   `json:"Status" xml:"Status"`
	Config                               string   `json:"Config" xml:"Config"`
	Logs                                 []string `json:"Logs" xml:"Logs"`
}

// CreateGetFeatureConsistencyCheckJobRequest creates a request to invoke GetFeatureConsistencyCheckJob API
func CreateGetFeatureConsistencyCheckJobRequest() (request *GetFeatureConsistencyCheckJobRequest) {
	request = &GetFeatureConsistencyCheckJobRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "GetFeatureConsistencyCheckJob", "/api/v1/featureconsistencycheck/jobs/[FeatureConsistencyCheckJobId]", "", "")
	request.Method = requests.GET
	return
}

// CreateGetFeatureConsistencyCheckJobResponse creates a response to parse from GetFeatureConsistencyCheckJob response
func CreateGetFeatureConsistencyCheckJobResponse() (response *GetFeatureConsistencyCheckJobResponse) {
	response = &GetFeatureConsistencyCheckJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
