package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteInstanceResource invokes the pairecservice.DeleteInstanceResource API synchronously
func (client *Client) DeleteInstanceResource(request *DeleteInstanceResourceRequest) (response *DeleteInstanceResourceResponse, err error) {
	response = CreateDeleteInstanceResourceResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteInstanceResourceWithChan invokes the pairecservice.DeleteInstanceResource API asynchronously
func (client *Client) DeleteInstanceResourceWithChan(request *DeleteInstanceResourceRequest) (<-chan *DeleteInstanceResourceResponse, <-chan error) {
	responseChan := make(chan *DeleteInstanceResourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteInstanceResource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteInstanceResourceWithCallback invokes the pairecservice.DeleteInstanceResource API asynchronously
func (client *Client) DeleteInstanceResourceWithCallback(request *DeleteInstanceResourceRequest, callback func(response *DeleteInstanceResourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteInstanceResourceResponse
		var err error
		defer close(result)
		response, err = client.DeleteInstanceResource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteInstanceResourceRequest is the request struct for api DeleteInstanceResource
type DeleteInstanceResourceRequest struct {
	*requests.RoaRequest
	ResourceId string `position:"Path" name:"ResourceId"`
	InstanceId string `position:"Path" name:"InstanceId"`
}

// DeleteInstanceResourceResponse is the response struct for api DeleteInstanceResource
type DeleteInstanceResourceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteInstanceResourceRequest creates a request to invoke DeleteInstanceResource API
func CreateDeleteInstanceResourceRequest() (request *DeleteInstanceResourceRequest) {
	request = &DeleteInstanceResourceRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "DeleteInstanceResource", "/api/v1/instances/[InstanceId]/resources/[ResourceId]", "", "")
	request.Method = requests.DELETE
	return
}

// CreateDeleteInstanceResourceResponse creates a response to parse from DeleteInstanceResource response
func CreateDeleteInstanceResourceResponse() (response *DeleteInstanceResourceResponse) {
	response = &DeleteInstanceResourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
