package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteABMetricGroup invokes the pairecservice.DeleteABMetricGroup API synchronously
func (client *Client) DeleteABMetricGroup(request *DeleteABMetricGroupRequest) (response *DeleteABMetricGroupResponse, err error) {
	response = CreateDeleteABMetricGroupResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteABMetricGroupWithChan invokes the pairecservice.DeleteABMetricGroup API asynchronously
func (client *Client) DeleteABMetricGroupWithChan(request *DeleteABMetricGroupRequest) (<-chan *DeleteABMetricGroupResponse, <-chan error) {
	responseChan := make(chan *DeleteABMetricGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteABMetricGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteABMetricGroupWithCallback invokes the pairecservice.DeleteABMetricGroup API asynchronously
func (client *Client) DeleteABMetricGroupWithCallback(request *DeleteABMetricGroupRequest, callback func(response *DeleteABMetricGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteABMetricGroupResponse
		var err error
		defer close(result)
		response, err = client.DeleteABMetricGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteABMetricGroupRequest is the request struct for api DeleteABMetricGroup
type DeleteABMetricGroupRequest struct {
	*requests.RoaRequest
	InstanceId      string `position:"Query" name:"InstanceId"`
	ABMetricGroupId string `position:"Path" name:"ABMetricGroupId"`
}

// DeleteABMetricGroupResponse is the response struct for api DeleteABMetricGroup
type DeleteABMetricGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteABMetricGroupRequest creates a request to invoke DeleteABMetricGroup API
func CreateDeleteABMetricGroupRequest() (request *DeleteABMetricGroupRequest) {
	request = &DeleteABMetricGroupRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "DeleteABMetricGroup", "/api/v1/abmetricgroups/[ABMetricGroupId]", "", "")
	request.Method = requests.DELETE
	return
}

// CreateDeleteABMetricGroupResponse creates a response to parse from DeleteABMetricGroup response
func CreateDeleteABMetricGroupResponse() (response *DeleteABMetricGroupResponse) {
	response = &DeleteABMetricGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
