package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateTrafficControlTarget invokes the pairecservice.CreateTrafficControlTarget API synchronously
func (client *Client) CreateTrafficControlTarget(request *CreateTrafficControlTargetRequest) (response *CreateTrafficControlTargetResponse, err error) {
	response = CreateCreateTrafficControlTargetResponse()
	err = client.DoAction(request, response)
	return
}

// CreateTrafficControlTargetWithChan invokes the pairecservice.CreateTrafficControlTarget API asynchronously
func (client *Client) CreateTrafficControlTargetWithChan(request *CreateTrafficControlTargetRequest) (<-chan *CreateTrafficControlTargetResponse, <-chan error) {
	responseChan := make(chan *CreateTrafficControlTargetResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateTrafficControlTarget(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateTrafficControlTargetWithCallback invokes the pairecservice.CreateTrafficControlTarget API asynchronously
func (client *Client) CreateTrafficControlTargetWithCallback(request *CreateTrafficControlTargetRequest, callback func(response *CreateTrafficControlTargetResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateTrafficControlTargetResponse
		var err error
		defer close(result)
		response, err = client.CreateTrafficControlTarget(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateTrafficControlTargetRequest is the request struct for api CreateTrafficControlTarget
type CreateTrafficControlTargetRequest struct {
	*requests.RoaRequest
	Body string `position:"Body" name:"body"`
}

// CreateTrafficControlTargetResponse is the response struct for api CreateTrafficControlTarget
type CreateTrafficControlTargetResponse struct {
	*responses.BaseResponse
	RequestId              string `json:"RequestId" xml:"RequestId"`
	TrafficControlTargetId string `json:"TrafficControlTargetId" xml:"TrafficControlTargetId"`
}

// CreateCreateTrafficControlTargetRequest creates a request to invoke CreateTrafficControlTarget API
func CreateCreateTrafficControlTargetRequest() (request *CreateTrafficControlTargetRequest) {
	request = &CreateTrafficControlTargetRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "CreateTrafficControlTarget", "/api/v1/trafficcontroltargets", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateTrafficControlTargetResponse creates a response to parse from CreateTrafficControlTarget response
func CreateCreateTrafficControlTargetResponse() (response *CreateTrafficControlTargetResponse) {
	response = &CreateTrafficControlTargetResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
