package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ApplyEngineConfig invokes the pairecservice.ApplyEngineConfig API synchronously
func (client *Client) ApplyEngineConfig(request *ApplyEngineConfigRequest) (response *ApplyEngineConfigResponse, err error) {
	response = CreateApplyEngineConfigResponse()
	err = client.DoAction(request, response)
	return
}

// ApplyEngineConfigWithChan invokes the pairecservice.ApplyEngineConfig API asynchronously
func (client *Client) ApplyEngineConfigWithChan(request *ApplyEngineConfigRequest) (<-chan *ApplyEngineConfigResponse, <-chan error) {
	responseChan := make(chan *ApplyEngineConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ApplyEngineConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ApplyEngineConfigWithCallback invokes the pairecservice.ApplyEngineConfig API asynchronously
func (client *Client) ApplyEngineConfigWithCallback(request *ApplyEngineConfigRequest, callback func(response *ApplyEngineConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ApplyEngineConfigResponse
		var err error
		defer close(result)
		response, err = client.ApplyEngineConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ApplyEngineConfigRequest is the request struct for api ApplyEngineConfig
type ApplyEngineConfigRequest struct {
	*requests.RoaRequest
	EngineConfigId string `position:"Path" name:"EngineConfigId"`
	InstanceId     string `position:"Query" name:"InstanceId"`
}

// ApplyEngineConfigResponse is the response struct for api ApplyEngineConfig
type ApplyEngineConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateApplyEngineConfigRequest creates a request to invoke ApplyEngineConfig API
func CreateApplyEngineConfigRequest() (request *ApplyEngineConfigRequest) {
	request = &ApplyEngineConfigRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "ApplyEngineConfig", "/api/v1/engineconfigs/[EngineConfigId]/action/apply", "", "")
	request.Method = requests.POST
	return
}

// CreateApplyEngineConfigResponse creates a response to parse from ApplyEngineConfig response
func CreateApplyEngineConfigResponse() (response *ApplyEngineConfigResponse) {
	response = &ApplyEngineConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
