package paifeaturestore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateLabelTable invokes the paifeaturestore.CreateLabelTable API synchronously
func (client *Client) CreateLabelTable(request *CreateLabelTableRequest) (response *CreateLabelTableResponse, err error) {
	response = CreateCreateLabelTableResponse()
	err = client.DoAction(request, response)
	return
}

// CreateLabelTableWithChan invokes the paifeaturestore.CreateLabelTable API asynchronously
func (client *Client) CreateLabelTableWithChan(request *CreateLabelTableRequest) (<-chan *CreateLabelTableResponse, <-chan error) {
	responseChan := make(chan *CreateLabelTableResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateLabelTable(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateLabelTableWithCallback invokes the paifeaturestore.CreateLabelTable API asynchronously
func (client *Client) CreateLabelTableWithCallback(request *CreateLabelTableRequest, callback func(response *CreateLabelTableResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateLabelTableResponse
		var err error
		defer close(result)
		response, err = client.CreateLabelTable(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateLabelTableRequest is the request struct for api CreateLabelTable
type CreateLabelTableRequest struct {
	*requests.RoaRequest
	Body       string `position:"Body" name:"body"`
	InstanceId string `position:"Path" name:"InstanceId"`
}

// CreateLabelTableResponse is the response struct for api CreateLabelTable
type CreateLabelTableResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	LabelTableId string `json:"LabelTableId" xml:"LabelTableId"`
}

// CreateCreateLabelTableRequest creates a request to invoke CreateLabelTable API
func CreateCreateLabelTableRequest() (request *CreateLabelTableRequest) {
	request = &CreateLabelTableRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiFeatureStore", "2023-06-21", "CreateLabelTable", "/api/v1/instances/[InstanceId]/labeltables", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateLabelTableResponse creates a response to parse from CreateLabelTable response
func CreateCreateLabelTableResponse() (response *CreateLabelTableResponse) {
	response = &CreateLabelTableResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
