package paielasticdatasetaccelerator

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateEndpoint invokes the paielasticdatasetaccelerator.CreateEndpoint API synchronously
func (client *Client) CreateEndpoint(request *CreateEndpointRequest) (response *CreateEndpointResponse, err error) {
	response = CreateCreateEndpointResponse()
	err = client.DoAction(request, response)
	return
}

// CreateEndpointWithChan invokes the paielasticdatasetaccelerator.CreateEndpoint API asynchronously
func (client *Client) CreateEndpointWithChan(request *CreateEndpointRequest) (<-chan *CreateEndpointResponse, <-chan error) {
	responseChan := make(chan *CreateEndpointResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateEndpoint(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateEndpointWithCallback invokes the paielasticdatasetaccelerator.CreateEndpoint API asynchronously
func (client *Client) CreateEndpointWithCallback(request *CreateEndpointRequest, callback func(response *CreateEndpointResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateEndpointResponse
		var err error
		defer close(result)
		response, err = client.CreateEndpoint(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateEndpointRequest is the request struct for api CreateEndpoint
type CreateEndpointRequest struct {
	*requests.RoaRequest
	Body string `position:"Body" name:"body"`
}

// CreateEndpointResponse is the response struct for api CreateEndpoint
type CreateEndpointResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	EndpointId string `json:"EndpointId" xml:"EndpointId"`
}

// CreateCreateEndpointRequest creates a request to invoke CreateEndpoint API
func CreateCreateEndpointRequest() (request *CreateEndpointRequest) {
	request = &CreateEndpointRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PAIElasticDatasetAccelerator", "2022-08-01", "CreateEndpoint", "/api/v1/endpoints", "datasetacc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateEndpointResponse creates a response to parse from CreateEndpoint response
func CreateCreateEndpointResponse() (response *CreateEndpointResponse) {
	response = &CreateEndpointResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
