package paielasticdatasetaccelerator

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BindEndpoint invokes the paielasticdatasetaccelerator.BindEndpoint API synchronously
func (client *Client) BindEndpoint(request *BindEndpointRequest) (response *BindEndpointResponse, err error) {
	response = CreateBindEndpointResponse()
	err = client.DoAction(request, response)
	return
}

// BindEndpointWithChan invokes the paielasticdatasetaccelerator.BindEndpoint API asynchronously
func (client *Client) BindEndpointWithChan(request *BindEndpointRequest) (<-chan *BindEndpointResponse, <-chan error) {
	responseChan := make(chan *BindEndpointResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BindEndpoint(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BindEndpointWithCallback invokes the paielasticdatasetaccelerator.BindEndpoint API asynchronously
func (client *Client) BindEndpointWithCallback(request *BindEndpointRequest, callback func(response *BindEndpointResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BindEndpointResponse
		var err error
		defer close(result)
		response, err = client.BindEndpoint(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BindEndpointRequest is the request struct for api BindEndpoint
type BindEndpointRequest struct {
	*requests.RoaRequest
	EndpointId string `position:"Path" name:"EndpointId"`
	SlotId     string `position:"Path" name:"SlotId"`
}

// BindEndpointResponse is the response struct for api BindEndpoint
type BindEndpointResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateBindEndpointRequest creates a request to invoke BindEndpoint API
func CreateBindEndpointRequest() (request *BindEndpointRequest) {
	request = &BindEndpointRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PAIElasticDatasetAccelerator", "2022-08-01", "BindEndpoint", "/api/v1/endpoints/[EndpointId]/slots/[SlotId]", "datasetacc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateBindEndpointResponse creates a response to parse from BindEndpoint response
func CreateBindEndpointResponse() (response *BindEndpointResponse) {
	response = &BindEndpointResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
