package outboundbot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeJobGroupExportTaskProgress invokes the outboundbot.DescribeJobGroupExportTaskProgress API synchronously
func (client *Client) DescribeJobGroupExportTaskProgress(request *DescribeJobGroupExportTaskProgressRequest) (response *DescribeJobGroupExportTaskProgressResponse, err error) {
	response = CreateDescribeJobGroupExportTaskProgressResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeJobGroupExportTaskProgressWithChan invokes the outboundbot.DescribeJobGroupExportTaskProgress API asynchronously
func (client *Client) DescribeJobGroupExportTaskProgressWithChan(request *DescribeJobGroupExportTaskProgressRequest) (<-chan *DescribeJobGroupExportTaskProgressResponse, <-chan error) {
	responseChan := make(chan *DescribeJobGroupExportTaskProgressResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeJobGroupExportTaskProgress(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeJobGroupExportTaskProgressWithCallback invokes the outboundbot.DescribeJobGroupExportTaskProgress API asynchronously
func (client *Client) DescribeJobGroupExportTaskProgressWithCallback(request *DescribeJobGroupExportTaskProgressRequest, callback func(response *DescribeJobGroupExportTaskProgressResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeJobGroupExportTaskProgressResponse
		var err error
		defer close(result)
		response, err = client.DescribeJobGroupExportTaskProgress(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeJobGroupExportTaskProgressRequest is the request struct for api DescribeJobGroupExportTaskProgress
type DescribeJobGroupExportTaskProgressRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
	TaskId     string `position:"Query" name:"TaskId"`
}

// DescribeJobGroupExportTaskProgressResponse is the response struct for api DescribeJobGroupExportTaskProgress
type DescribeJobGroupExportTaskProgressResponse struct {
	*responses.BaseResponse
	HttpStatusCode int     `json:"HttpStatusCode" xml:"HttpStatusCode"`
	FileHttpUrl    string  `json:"FileHttpUrl" xml:"FileHttpUrl"`
	Progress       float64 `json:"Progress" xml:"Progress"`
	RequestId      string  `json:"RequestId" xml:"RequestId"`
	Success        bool    `json:"Success" xml:"Success"`
	Code           string  `json:"Code" xml:"Code"`
	Message        string  `json:"Message" xml:"Message"`
}

// CreateDescribeJobGroupExportTaskProgressRequest creates a request to invoke DescribeJobGroupExportTaskProgress API
func CreateDescribeJobGroupExportTaskProgressRequest() (request *DescribeJobGroupExportTaskProgressRequest) {
	request = &DescribeJobGroupExportTaskProgressRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OutboundBot", "2019-12-26", "DescribeJobGroupExportTaskProgress", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeJobGroupExportTaskProgressResponse creates a response to parse from DescribeJobGroupExportTaskProgress response
func CreateDescribeJobGroupExportTaskProgressResponse() (response *DescribeJobGroupExportTaskProgressResponse) {
	response = &DescribeJobGroupExportTaskProgressResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
