package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateSearchStrategy invokes the opensearch.UpdateSearchStrategy API synchronously
func (client *Client) UpdateSearchStrategy(request *UpdateSearchStrategyRequest) (response *UpdateSearchStrategyResponse, err error) {
	response = CreateUpdateSearchStrategyResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateSearchStrategyWithChan invokes the opensearch.UpdateSearchStrategy API asynchronously
func (client *Client) UpdateSearchStrategyWithChan(request *UpdateSearchStrategyRequest) (<-chan *UpdateSearchStrategyResponse, <-chan error) {
	responseChan := make(chan *UpdateSearchStrategyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateSearchStrategy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateSearchStrategyWithCallback invokes the opensearch.UpdateSearchStrategy API asynchronously
func (client *Client) UpdateSearchStrategyWithCallback(request *UpdateSearchStrategyRequest, callback func(response *UpdateSearchStrategyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateSearchStrategyResponse
		var err error
		defer close(result)
		response, err = client.UpdateSearchStrategy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateSearchStrategyRequest is the request struct for api UpdateSearchStrategy
type UpdateSearchStrategyRequest struct {
	*requests.RoaRequest
	StrategyName     string `position:"Path" name:"strategyName"`
	AppId            string `position:"Path" name:"appId"`
	AppGroupIdentity string `position:"Path" name:"appGroupIdentity"`
}

// UpdateSearchStrategyResponse is the response struct for api UpdateSearchStrategy
type UpdateSearchStrategyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
}

// CreateUpdateSearchStrategyRequest creates a request to invoke UpdateSearchStrategy API
func CreateUpdateSearchStrategyRequest() (request *UpdateSearchStrategyRequest) {
	request = &UpdateSearchStrategyRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "UpdateSearchStrategy", "/v4/openapi/app-groups/[appGroupIdentity]/apps/[appId]/search-strategies/[strategyName]", "", "")
	request.Method = requests.PUT
	return
}

// CreateUpdateSearchStrategyResponse creates a response to parse from UpdateSearchStrategy response
func CreateUpdateSearchStrategyResponse() (response *UpdateSearchStrategyResponse) {
	response = &UpdateSearchStrategyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
