package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeRegion invokes the opensearch.DescribeRegion API synchronously
func (client *Client) DescribeRegion(request *DescribeRegionRequest) (response *DescribeRegionResponse, err error) {
	response = CreateDescribeRegionResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeRegionWithChan invokes the opensearch.DescribeRegion API asynchronously
func (client *Client) DescribeRegionWithChan(request *DescribeRegionRequest) (<-chan *DescribeRegionResponse, <-chan error) {
	responseChan := make(chan *DescribeRegionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeRegion(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeRegionWithCallback invokes the opensearch.DescribeRegion API asynchronously
func (client *Client) DescribeRegionWithCallback(request *DescribeRegionRequest, callback func(response *DescribeRegionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeRegionResponse
		var err error
		defer close(result)
		response, err = client.DescribeRegion(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeRegionRequest is the request struct for api DescribeRegion
type DescribeRegionRequest struct {
	*requests.RoaRequest
}

// DescribeRegionResponse is the response struct for api DescribeRegion
type DescribeRegionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
	Result    Result `json:"result" xml:"result"`
}

// CreateDescribeRegionRequest creates a request to invoke DescribeRegion API
func CreateDescribeRegionRequest() (request *DescribeRegionRequest) {
	request = &DescribeRegionRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "DescribeRegion", "/v4/openapi/region", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeRegionResponse creates a response to parse from DescribeRegion response
func CreateDescribeRegionResponse() (response *DescribeRegionResponse) {
	response = &DescribeRegionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
