package openanalytics_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetPartitions invokes the openanalytics_open.GetPartitions API synchronously
func (client *Client) GetPartitions(request *GetPartitionsRequest) (response *GetPartitionsResponse, err error) {
	response = CreateGetPartitionsResponse()
	err = client.DoAction(request, response)
	return
}

// GetPartitionsWithChan invokes the openanalytics_open.GetPartitions API asynchronously
func (client *Client) GetPartitionsWithChan(request *GetPartitionsRequest) (<-chan *GetPartitionsResponse, <-chan error) {
	responseChan := make(chan *GetPartitionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetPartitions(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetPartitionsWithCallback invokes the openanalytics_open.GetPartitions API asynchronously
func (client *Client) GetPartitionsWithCallback(request *GetPartitionsRequest, callback func(response *GetPartitionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetPartitionsResponse
		var err error
		defer close(result)
		response, err = client.GetPartitions(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetPartitionsRequest is the request struct for api GetPartitions
type GetPartitionsRequest struct {
	*requests.RpcRequest
	DbName    string           `position:"Query" name:"DbName"`
	MaxParts  requests.Integer `position:"Query" name:"MaxParts"`
	TableName string           `position:"Query" name:"TableName"`
}

// GetPartitionsResponse is the response struct for api GetPartitions
type GetPartitionsResponse struct {
	*responses.BaseResponse
	RequestId  string           `json:"RequestId" xml:"RequestId"`
	Message    string           `json:"Message" xml:"Message"`
	Code       string           `json:"Code" xml:"Code"`
	Success    bool             `json:"Success" xml:"Success"`
	Partitions []PartitionModel `json:"Partitions" xml:"Partitions"`
}

// CreateGetPartitionsRequest creates a request to invoke GetPartitions API
func CreateGetPartitionsRequest() (request *GetPartitionsRequest) {
	request = &GetPartitionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("openanalytics-open", "2020-09-28", "GetPartitions", "openanalytics", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetPartitionsResponse creates a response to parse from GetPartitions response
func CreateGetPartitionsResponse() (response *GetPartitionsResponse) {
	response = &GetPartitionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
