package ocr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RecognizePdf invokes the ocr.RecognizePdf API synchronously
func (client *Client) RecognizePdf(request *RecognizePdfRequest) (response *RecognizePdfResponse, err error) {
	response = CreateRecognizePdfResponse()
	err = client.DoAction(request, response)
	return
}

// RecognizePdfWithChan invokes the ocr.RecognizePdf API asynchronously
func (client *Client) RecognizePdfWithChan(request *RecognizePdfRequest) (<-chan *RecognizePdfResponse, <-chan error) {
	responseChan := make(chan *RecognizePdfResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RecognizePdf(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RecognizePdfWithCallback invokes the ocr.RecognizePdf API asynchronously
func (client *Client) RecognizePdfWithCallback(request *RecognizePdfRequest, callback func(response *RecognizePdfResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RecognizePdfResponse
		var err error
		defer close(result)
		response, err = client.RecognizePdf(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RecognizePdfRequest is the request struct for api RecognizePdf
type RecognizePdfRequest struct {
	*requests.RpcRequest
	FileURL string `position:"Body" name:"FileURL"`
}

// RecognizePdfResponse is the response struct for api RecognizePdf
type RecognizePdfResponse struct {
	*responses.BaseResponse
	RequestId string             `json:"RequestId" xml:"RequestId"`
	Code      string             `json:"Code" xml:"Code"`
	Message   string             `json:"Message" xml:"Message"`
	Data      DataInRecognizePdf `json:"Data" xml:"Data"`
}

// CreateRecognizePdfRequest creates a request to invoke RecognizePdf API
func CreateRecognizePdfRequest() (request *RecognizePdfRequest) {
	request = &RecognizePdfRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ocr", "2019-12-30", "RecognizePdf", "ocr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRecognizePdfResponse creates a response to parse from RecognizePdf response
func CreateRecognizePdfResponse() (response *RecognizePdfResponse) {
	response = &RecognizePdfResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
