package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyInstanceTemporaryCapacity invokes the oceanbasepro.ModifyInstanceTemporaryCapacity API synchronously
func (client *Client) ModifyInstanceTemporaryCapacity(request *ModifyInstanceTemporaryCapacityRequest) (response *ModifyInstanceTemporaryCapacityResponse, err error) {
	response = CreateModifyInstanceTemporaryCapacityResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyInstanceTemporaryCapacityWithChan invokes the oceanbasepro.ModifyInstanceTemporaryCapacity API asynchronously
func (client *Client) ModifyInstanceTemporaryCapacityWithChan(request *ModifyInstanceTemporaryCapacityRequest) (<-chan *ModifyInstanceTemporaryCapacityResponse, <-chan error) {
	responseChan := make(chan *ModifyInstanceTemporaryCapacityResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyInstanceTemporaryCapacity(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyInstanceTemporaryCapacityWithCallback invokes the oceanbasepro.ModifyInstanceTemporaryCapacity API asynchronously
func (client *Client) ModifyInstanceTemporaryCapacityWithCallback(request *ModifyInstanceTemporaryCapacityRequest, callback func(response *ModifyInstanceTemporaryCapacityResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyInstanceTemporaryCapacityResponse
		var err error
		defer close(result)
		response, err = client.ModifyInstanceTemporaryCapacity(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyInstanceTemporaryCapacityRequest is the request struct for api ModifyInstanceTemporaryCapacity
type ModifyInstanceTemporaryCapacityRequest struct {
	*requests.RpcRequest
	DiskSize       string `position:"Body" name:"DiskSize"`
	Spec           string `position:"Body" name:"Spec"`
	InstanceId     string `position:"Body" name:"InstanceId"`
	AcceptLanguage string `position:"Body" name:"AcceptLanguage"`
}

// ModifyInstanceTemporaryCapacityResponse is the response struct for api ModifyInstanceTemporaryCapacity
type ModifyInstanceTemporaryCapacityResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyInstanceTemporaryCapacityRequest creates a request to invoke ModifyInstanceTemporaryCapacity API
func CreateModifyInstanceTemporaryCapacityRequest() (request *ModifyInstanceTemporaryCapacityRequest) {
	request = &ModifyInstanceTemporaryCapacityRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "ModifyInstanceTemporaryCapacity", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyInstanceTemporaryCapacityResponse creates a response to parse from ModifyInstanceTemporaryCapacity response
func CreateModifyInstanceTemporaryCapacityResponse() (response *ModifyInstanceTemporaryCapacityResponse) {
	response = &ModifyInstanceTemporaryCapacityResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
