package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeTenantUsers invokes the oceanbasepro.DescribeTenantUsers API synchronously
func (client *Client) DescribeTenantUsers(request *DescribeTenantUsersRequest) (response *DescribeTenantUsersResponse, err error) {
	response = CreateDescribeTenantUsersResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeTenantUsersWithChan invokes the oceanbasepro.DescribeTenantUsers API asynchronously
func (client *Client) DescribeTenantUsersWithChan(request *DescribeTenantUsersRequest) (<-chan *DescribeTenantUsersResponse, <-chan error) {
	responseChan := make(chan *DescribeTenantUsersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeTenantUsers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeTenantUsersWithCallback invokes the oceanbasepro.DescribeTenantUsers API asynchronously
func (client *Client) DescribeTenantUsersWithCallback(request *DescribeTenantUsersRequest, callback func(response *DescribeTenantUsersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeTenantUsersResponse
		var err error
		defer close(result)
		response, err = client.DescribeTenantUsers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeTenantUsersRequest is the request struct for api DescribeTenantUsers
type DescribeTenantUsersRequest struct {
	*requests.RpcRequest
	SearchKey  string           `position:"Body" name:"SearchKey"`
	PageNumber requests.Integer `position:"Body" name:"PageNumber"`
	TenantId   string           `position:"Body" name:"TenantId"`
	PageSize   requests.Integer `position:"Body" name:"PageSize"`
	UserName   string           `position:"Body" name:"UserName"`
}

// DescribeTenantUsersResponse is the response struct for api DescribeTenantUsers
type DescribeTenantUsersResponse struct {
	*responses.BaseResponse
	TotalCount  int               `json:"TotalCount" xml:"TotalCount"`
	RequestId   string            `json:"RequestId" xml:"RequestId"`
	TenantUsers []TenantUsersItem `json:"TenantUsers" xml:"TenantUsers"`
}

// CreateDescribeTenantUsersRequest creates a request to invoke DescribeTenantUsers API
func CreateDescribeTenantUsersRequest() (request *DescribeTenantUsersRequest) {
	request = &DescribeTenantUsersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "DescribeTenantUsers", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeTenantUsersResponse creates a response to parse from DescribeTenantUsers response
func CreateDescribeTenantUsersResponse() (response *DescribeTenantUsersResponse) {
	response = &DescribeTenantUsersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
