package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeTenantMetrics invokes the oceanbasepro.DescribeTenantMetrics API synchronously
func (client *Client) DescribeTenantMetrics(request *DescribeTenantMetricsRequest) (response *DescribeTenantMetricsResponse, err error) {
	response = CreateDescribeTenantMetricsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeTenantMetricsWithChan invokes the oceanbasepro.DescribeTenantMetrics API asynchronously
func (client *Client) DescribeTenantMetricsWithChan(request *DescribeTenantMetricsRequest) (<-chan *DescribeTenantMetricsResponse, <-chan error) {
	responseChan := make(chan *DescribeTenantMetricsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeTenantMetrics(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeTenantMetricsWithCallback invokes the oceanbasepro.DescribeTenantMetrics API asynchronously
func (client *Client) DescribeTenantMetricsWithCallback(request *DescribeTenantMetricsRequest, callback func(response *DescribeTenantMetricsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeTenantMetricsResponse
		var err error
		defer close(result)
		response, err = client.DescribeTenantMetrics(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeTenantMetricsRequest is the request struct for api DescribeTenantMetrics
type DescribeTenantMetricsRequest struct {
	*requests.RpcRequest
	TenantIdList string           `position:"Body" name:"TenantIdList"`
	StartTime    string           `position:"Body" name:"StartTime"`
	PageNumber   requests.Integer `position:"Body" name:"PageNumber"`
	PageSize     requests.Integer `position:"Body" name:"PageSize"`
	TenantId     string           `position:"Body" name:"TenantId"`
	EndTime      string           `position:"Body" name:"EndTime"`
	InstanceId   string           `position:"Body" name:"InstanceId"`
	TenantName   string           `position:"Body" name:"TenantName"`
	Metrics      string           `position:"Body" name:"Metrics"`
}

// DescribeTenantMetricsResponse is the response struct for api DescribeTenantMetrics
type DescribeTenantMetricsResponse struct {
	*responses.BaseResponse
	TotalCount    int    `json:"TotalCount" xml:"TotalCount"`
	RequestId     string `json:"RequestId" xml:"RequestId"`
	TenantMetrics string `json:"TenantMetrics" xml:"TenantMetrics"`
}

// CreateDescribeTenantMetricsRequest creates a request to invoke DescribeTenantMetrics API
func CreateDescribeTenantMetricsRequest() (request *DescribeTenantMetricsRequest) {
	request = &DescribeTenantMetricsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "DescribeTenantMetrics", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeTenantMetricsResponse creates a response to parse from DescribeTenantMetrics response
func CreateDescribeTenantMetricsResponse() (response *DescribeTenantMetricsResponse) {
	response = &DescribeTenantMetricsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
