package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSessionList invokes the oceanbasepro.DescribeSessionList API synchronously
func (client *Client) DescribeSessionList(request *DescribeSessionListRequest) (response *DescribeSessionListResponse, err error) {
	response = CreateDescribeSessionListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSessionListWithChan invokes the oceanbasepro.DescribeSessionList API asynchronously
func (client *Client) DescribeSessionListWithChan(request *DescribeSessionListRequest) (<-chan *DescribeSessionListResponse, <-chan error) {
	responseChan := make(chan *DescribeSessionListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSessionList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSessionListWithCallback invokes the oceanbasepro.DescribeSessionList API asynchronously
func (client *Client) DescribeSessionListWithCallback(request *DescribeSessionListRequest, callback func(response *DescribeSessionListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSessionListResponse
		var err error
		defer close(result)
		response, err = client.DescribeSessionList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSessionListRequest is the request struct for api DescribeSessionList
type DescribeSessionListRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Body" name:"InstanceId"`
	TenantId   string `position:"Body" name:"TenantId"`
}

// DescribeSessionListResponse is the response struct for api DescribeSessionList
type DescribeSessionListResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateDescribeSessionListRequest creates a request to invoke DescribeSessionList API
func CreateDescribeSessionListRequest() (request *DescribeSessionListRequest) {
	request = &DescribeSessionListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "DescribeSessionList", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeSessionListResponse creates a response to parse from DescribeSessionList response
func CreateDescribeSessionListResponse() (response *DescribeSessionListResponse) {
	response = &DescribeSessionListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
