package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateSecurityIpGroup invokes the oceanbasepro.CreateSecurityIpGroup API synchronously
func (client *Client) CreateSecurityIpGroup(request *CreateSecurityIpGroupRequest) (response *CreateSecurityIpGroupResponse, err error) {
	response = CreateCreateSecurityIpGroupResponse()
	err = client.DoAction(request, response)
	return
}

// CreateSecurityIpGroupWithChan invokes the oceanbasepro.CreateSecurityIpGroup API asynchronously
func (client *Client) CreateSecurityIpGroupWithChan(request *CreateSecurityIpGroupRequest) (<-chan *CreateSecurityIpGroupResponse, <-chan error) {
	responseChan := make(chan *CreateSecurityIpGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateSecurityIpGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateSecurityIpGroupWithCallback invokes the oceanbasepro.CreateSecurityIpGroup API asynchronously
func (client *Client) CreateSecurityIpGroupWithCallback(request *CreateSecurityIpGroupRequest, callback func(response *CreateSecurityIpGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateSecurityIpGroupResponse
		var err error
		defer close(result)
		response, err = client.CreateSecurityIpGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateSecurityIpGroupRequest is the request struct for api CreateSecurityIpGroup
type CreateSecurityIpGroupRequest struct {
	*requests.RpcRequest
	SecurityIps         string `position:"Body" name:"SecurityIps"`
	SecurityIpGroupName string `position:"Body" name:"SecurityIpGroupName"`
	InstanceId          string `position:"Body" name:"InstanceId"`
}

// CreateSecurityIpGroupResponse is the response struct for api CreateSecurityIpGroup
type CreateSecurityIpGroupResponse struct {
	*responses.BaseResponse
	RequestId       string          `json:"RequestId" xml:"RequestId"`
	SecurityIpGroup SecurityIpGroup `json:"SecurityIpGroup" xml:"SecurityIpGroup"`
}

// CreateCreateSecurityIpGroupRequest creates a request to invoke CreateSecurityIpGroup API
func CreateCreateSecurityIpGroupRequest() (request *CreateSecurityIpGroupRequest) {
	request = &CreateSecurityIpGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "CreateSecurityIpGroup", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateSecurityIpGroupResponse creates a response to parse from CreateSecurityIpGroup response
func CreateCreateSecurityIpGroupResponse() (response *CreateSecurityIpGroupResponse) {
	response = &CreateSecurityIpGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
