package objectdet

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DetectIPCObject invokes the objectdet.DetectIPCObject API synchronously
func (client *Client) DetectIPCObject(request *DetectIPCObjectRequest) (response *DetectIPCObjectResponse, err error) {
	response = CreateDetectIPCObjectResponse()
	err = client.DoAction(request, response)
	return
}

// DetectIPCObjectWithChan invokes the objectdet.DetectIPCObject API asynchronously
func (client *Client) DetectIPCObjectWithChan(request *DetectIPCObjectRequest) (<-chan *DetectIPCObjectResponse, <-chan error) {
	responseChan := make(chan *DetectIPCObjectResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DetectIPCObject(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DetectIPCObjectWithCallback invokes the objectdet.DetectIPCObject API asynchronously
func (client *Client) DetectIPCObjectWithCallback(request *DetectIPCObjectRequest, callback func(response *DetectIPCObjectResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DetectIPCObjectResponse
		var err error
		defer close(result)
		response, err = client.DetectIPCObject(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DetectIPCObjectRequest is the request struct for api DetectIPCObject
type DetectIPCObjectRequest struct {
	*requests.RpcRequest
	ImageURL string `position:"Body" name:"ImageURL"`
}

// DetectIPCObjectResponse is the response struct for api DetectIPCObject
type DetectIPCObjectResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDetectIPCObjectRequest creates a request to invoke DetectIPCObject API
func CreateDetectIPCObjectRequest() (request *DetectIPCObjectRequest) {
	request = &DetectIPCObjectRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("objectdet", "2019-12-30", "DetectIPCObject", "objectdet", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDetectIPCObjectResponse creates a response to parse from DetectIPCObject response
func CreateDetectIPCObjectResponse() (response *DetectIPCObjectResponse) {
	response = &DetectIPCObjectResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
