package nlb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateSecurityPolicyAttribute invokes the nlb.UpdateSecurityPolicyAttribute API synchronously
func (client *Client) UpdateSecurityPolicyAttribute(request *UpdateSecurityPolicyAttributeRequest) (response *UpdateSecurityPolicyAttributeResponse, err error) {
	response = CreateUpdateSecurityPolicyAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateSecurityPolicyAttributeWithChan invokes the nlb.UpdateSecurityPolicyAttribute API asynchronously
func (client *Client) UpdateSecurityPolicyAttributeWithChan(request *UpdateSecurityPolicyAttributeRequest) (<-chan *UpdateSecurityPolicyAttributeResponse, <-chan error) {
	responseChan := make(chan *UpdateSecurityPolicyAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateSecurityPolicyAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateSecurityPolicyAttributeWithCallback invokes the nlb.UpdateSecurityPolicyAttribute API asynchronously
func (client *Client) UpdateSecurityPolicyAttributeWithCallback(request *UpdateSecurityPolicyAttributeRequest, callback func(response *UpdateSecurityPolicyAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateSecurityPolicyAttributeResponse
		var err error
		defer close(result)
		response, err = client.UpdateSecurityPolicyAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateSecurityPolicyAttributeRequest is the request struct for api UpdateSecurityPolicyAttribute
type UpdateSecurityPolicyAttributeRequest struct {
	*requests.RpcRequest
	ClientToken        string           `position:"Body" name:"ClientToken"`
	Ciphers            *[]string        `position:"Body" name:"Ciphers"  type:"Repeated"`
	TlsVersions        *[]string        `position:"Body" name:"TlsVersions"  type:"Repeated"`
	SecurityPolicyName string           `position:"Body" name:"SecurityPolicyName"`
	DryRun             requests.Boolean `position:"Body" name:"DryRun"`
	SecurityPolicyId   string           `position:"Body" name:"SecurityPolicyId"`
}

// UpdateSecurityPolicyAttributeResponse is the response struct for api UpdateSecurityPolicyAttribute
type UpdateSecurityPolicyAttributeResponse struct {
	*responses.BaseResponse
	RequestId        string `json:"RequestId" xml:"RequestId"`
	Success          bool   `json:"Success" xml:"Success"`
	Code             string `json:"Code" xml:"Code"`
	Message          string `json:"Message" xml:"Message"`
	HttpStatusCode   int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	DynamicCode      string `json:"DynamicCode" xml:"DynamicCode"`
	DynamicMessage   string `json:"DynamicMessage" xml:"DynamicMessage"`
	SecurityPolicyId string `json:"SecurityPolicyId" xml:"SecurityPolicyId"`
	JobId            string `json:"JobId" xml:"JobId"`
}

// CreateUpdateSecurityPolicyAttributeRequest creates a request to invoke UpdateSecurityPolicyAttribute API
func CreateUpdateSecurityPolicyAttributeRequest() (request *UpdateSecurityPolicyAttributeRequest) {
	request = &UpdateSecurityPolicyAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Nlb", "2022-04-30", "UpdateSecurityPolicyAttribute", "nlb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateSecurityPolicyAttributeResponse creates a response to parse from UpdateSecurityPolicyAttribute response
func CreateUpdateSecurityPolicyAttributeResponse() (response *UpdateSecurityPolicyAttributeResponse) {
	response = &UpdateSecurityPolicyAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
