package nis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateAndAnalyzeNetworkPath invokes the nis.CreateAndAnalyzeNetworkPath API synchronously
func (client *Client) CreateAndAnalyzeNetworkPath(request *CreateAndAnalyzeNetworkPathRequest) (response *CreateAndAnalyzeNetworkPathResponse, err error) {
	response = CreateCreateAndAnalyzeNetworkPathResponse()
	err = client.DoAction(request, response)
	return
}

// CreateAndAnalyzeNetworkPathWithChan invokes the nis.CreateAndAnalyzeNetworkPath API asynchronously
func (client *Client) CreateAndAnalyzeNetworkPathWithChan(request *CreateAndAnalyzeNetworkPathRequest) (<-chan *CreateAndAnalyzeNetworkPathResponse, <-chan error) {
	responseChan := make(chan *CreateAndAnalyzeNetworkPathResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateAndAnalyzeNetworkPath(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateAndAnalyzeNetworkPathWithCallback invokes the nis.CreateAndAnalyzeNetworkPath API asynchronously
func (client *Client) CreateAndAnalyzeNetworkPathWithCallback(request *CreateAndAnalyzeNetworkPathRequest, callback func(response *CreateAndAnalyzeNetworkPathResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateAndAnalyzeNetworkPathResponse
		var err error
		defer close(result)
		response, err = client.CreateAndAnalyzeNetworkPath(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateAndAnalyzeNetworkPathRequest is the request struct for api CreateAndAnalyzeNetworkPath
type CreateAndAnalyzeNetworkPathRequest struct {
	*requests.RpcRequest
	TargetId        string           `position:"Query" name:"TargetId"`
	TargetType      string           `position:"Query" name:"TargetType"`
	TargetIpAddress string           `position:"Query" name:"TargetIpAddress"`
	SourcePort      requests.Integer `position:"Query" name:"SourcePort"`
	Protocol        string           `position:"Query" name:"Protocol"`
	SourceAliUid    requests.Integer `position:"Query" name:"SourceAliUid"`
	SourceType      string           `position:"Query" name:"SourceType"`
	AuditParam      string           `position:"Query" name:"AuditParam"`
	TargetPort      requests.Integer `position:"Query" name:"TargetPort"`
	SourceId        string           `position:"Query" name:"SourceId"`
	SourceIpAddress string           `position:"Query" name:"SourceIpAddress"`
	UseMultiAccount requests.Boolean `position:"Query" name:"UseMultiAccount"`
	TargetAliUid    requests.Integer `position:"Query" name:"TargetAliUid"`
}

// CreateAndAnalyzeNetworkPathResponse is the response struct for api CreateAndAnalyzeNetworkPath
type CreateAndAnalyzeNetworkPathResponse struct {
	*responses.BaseResponse
	RequestId                  string `json:"RequestId" xml:"RequestId"`
	NetworkReachableAnalysisId string `json:"NetworkReachableAnalysisId" xml:"NetworkReachableAnalysisId"`
	SourceId                   string `json:"SourceId" xml:"SourceId"`
	TargetId                   string `json:"TargetId" xml:"TargetId"`
	SourceType                 string `json:"SourceType" xml:"SourceType"`
	TargetType                 string `json:"TargetType" xml:"TargetType"`
	SourcePort                 string `json:"SourcePort" xml:"SourcePort"`
	TargetPort                 string `json:"TargetPort" xml:"TargetPort"`
	Protocol                   string `json:"Protocol" xml:"Protocol"`
	SourceIpAddress            string `json:"SourceIpAddress" xml:"SourceIpAddress"`
	TargetIpAddress            string `json:"TargetIpAddress" xml:"TargetIpAddress"`
}

// CreateCreateAndAnalyzeNetworkPathRequest creates a request to invoke CreateAndAnalyzeNetworkPath API
func CreateCreateAndAnalyzeNetworkPathRequest() (request *CreateAndAnalyzeNetworkPathRequest) {
	request = &CreateAndAnalyzeNetworkPathRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("nis", "2021-12-16", "CreateAndAnalyzeNetworkPath", "networkana", "openAPI")
	request.Method = requests.GET
	return
}

// CreateCreateAndAnalyzeNetworkPathResponse creates a response to parse from CreateAndAnalyzeNetworkPath response
func CreateCreateAndAnalyzeNetworkPathResponse() (response *CreateAndAnalyzeNetworkPathResponse) {
	response = &CreateAndAnalyzeNetworkPathResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
