package nas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDataFlow invokes the nas.DeleteDataFlow API synchronously
func (client *Client) DeleteDataFlow(request *DeleteDataFlowRequest) (response *DeleteDataFlowResponse, err error) {
	response = CreateDeleteDataFlowResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDataFlowWithChan invokes the nas.DeleteDataFlow API asynchronously
func (client *Client) DeleteDataFlowWithChan(request *DeleteDataFlowRequest) (<-chan *DeleteDataFlowResponse, <-chan error) {
	responseChan := make(chan *DeleteDataFlowResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDataFlow(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDataFlowWithCallback invokes the nas.DeleteDataFlow API asynchronously
func (client *Client) DeleteDataFlowWithCallback(request *DeleteDataFlowRequest, callback func(response *DeleteDataFlowResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDataFlowResponse
		var err error
		defer close(result)
		response, err = client.DeleteDataFlow(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDataFlowRequest is the request struct for api DeleteDataFlow
type DeleteDataFlowRequest struct {
	*requests.RpcRequest
	ClientToken  string           `position:"Query" name:"ClientToken"`
	FileSystemId string           `position:"Query" name:"FileSystemId"`
	DryRun       requests.Boolean `position:"Query" name:"DryRun"`
	DataFlowId   string           `position:"Query" name:"DataFlowId"`
}

// DeleteDataFlowResponse is the response struct for api DeleteDataFlow
type DeleteDataFlowResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteDataFlowRequest creates a request to invoke DeleteDataFlow API
func CreateDeleteDataFlowRequest() (request *DeleteDataFlowRequest) {
	request = &DeleteDataFlowRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("NAS", "2017-06-26", "DeleteDataFlow", "nas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteDataFlowResponse creates a response to parse from DeleteDataFlow response
func CreateDeleteDataFlowResponse() (response *DeleteDataFlowResponse) {
	response = &DeleteDataFlowResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
